<?php
error_reporting(E_ALL);
header('Content-type: text/html; charset=utf-8');

ob_start();
session_start();
$self_call = isset($_SERVER['HTTP_REFERER']) && strpos($_SERVER['HTTP_REFERER'], $_SERVER['PHP_SELF']) !== false;

session_regenerate_id(false); // Verhindert, dass die Session überschrieben wird

// Überprüfe, ob die Session noch existiert
if (!$self_call && !isset($_SESSION['access_token'])) {
    die("Fehler: Ungültiger Zugriff.");
}


if (!$self_call && (!isset($_GET['token']) || $_GET['token'] !== ($_SESSION['access_token'] ?? ''))) {
    die("Bitte rufe das Profil nur aus dem Chat auf.");
}



if (isset($_SESSION['chatuser'])) {
	$nickname= $_SESSION['chatuser'];
} else {
    $uri  = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
    $extra1 = 'logout.php';
    if (isset($_SERVER['HTTP_HOST'])) {
	    $host  = $_SERVER['HTTP_HOST'];
		if ( isset($_SERVER['HTTPS']) && strtolower($_SERVER['HTTPS']) != '' ) {
			header("Location: https://$host$uri/$extra1");
			exit();
		} else {
			header("Location: http://$host$uri/$extra1");
			exit();
		}
	} else {
		exit;
	}
}

header("Cache-Control: max-age=1");

include("chat_config.php");

if (isset($stil) && $stil <> 0) {
        $s = $stil;
} elseif (isset($_COOKIE["Style"])) {
	$s = $_COOKIE["Style"];
} else {
        $s = $default_skin;
}

// http://aktuell.de.selfhtml.org/artikel/css/mobile-endgeraete/
if(file_exists("check_mobile.php")) {
	require('check_mobile.php');
	if(check_mobile() === true) {
		$s = 7;
	}
}


if (isset($_COOKIE["schrift"])) {
	$schrift= $_COOKIE["schrift"] * 0.8;
} else {
	$schrift=80;
}


?>




<!DOCTYPE html>
<html lang="de">

<head>
<meta http-equiv="content-type" content="text/html;charset=utf-8" />
<meta name="description" content="Profil erstellen und bearbeiten - Der Chat von webdesign.weisshart.de" />
<meta name="keywords" content="@bots: please look for keywords in document body ;-)" />
<meta name="author" content="Dipl.-Ing.(FH) Fritz Weisshart und Co. GbR" />
<meta name="generator" content="notepad ;-)" />
<meta name="robots" content="index, follow" />
<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=1" /> 

<title>Chat Profil erstellen und bearbeiten</title>

<link rel="shortcut icon" href="favicon.ico" type="image/ico" />

<link rel="stylesheet" type="text/css" media="screen" href="chatcss<?php echo $s; ?>.php" />

<link rel="stylesheet" type="text/css" media="screen" href="profil.css?15" />


<!--[IF IE]>
<link rel="stylesheet" type="text/css" media="screen" href="profil_ie.css" />
<![ENDIF]-->

<script src="micoxUpload2.js"></script>


<?php
if ($s == 11 || $s == 12 || $s == 4) {
echo '
<style type="text/css">

fieldset {
border: 1px solid #555;
/* background-color: #004; */
padding: 10px;
}

form p {
color:#ff8;
}
input, select {
color:#ff8;
background:#333;
border: 1px yellow solid;
padding: 2px
}


input[type="submit"],
input[type="button"] {
cursor:pointer;
}


</style>
';
}


if ($s == 12 || $s== 6 || $s== 3) {
echo '
<style type="text/css">
html {font-size: 1em;padding:0 !important}
</style>
';
}

if ($s == 7) {
echo '
<style type="text/css">
html {padding:0 !important}
body {width:100vw;}
fieldset {padding:1em; }
.left, .right {margin-left:0 !important;margin-right:0;display:table-cell;text-align:left;}

input[type="text"] {max-width:85vw !important;}
input[type="radio"] {margin:.1em 0 0 0;}
input[type="button"], select {display:block}
label {max-width: 80%;display:inline-flex;}
</style>
';
}


if ($s != 12 && $s != 7 ) {
	echo '<style>body {font-size:'.$schrift.'% !important;}</style>';
}


if ($s == 14 ) {
	echo ' <style>@media (prefers-color-scheme: dark) {
		body::after {
			filter: invert(0);
		}
	}
	</style>';
}

if ($s == 14 ) {
	echo '
		<style>
		fieldset {
			background: rgba(255,255,255,.7);
		}
	</style>';
}




?>


</head>
<body>

<?php

$slash =" - ";
if (!isset($create_profile) || $create_profile != "yes") {
      echo '
      <p>Profile sind deaktiviert.</p>
      <p><a href="chat.php" onclick="history.back()"; return false;>Zur&uuml;ck zum Chat</a></p>
      ';
      exit;
}




if((isset($_SESSION['login']) && $_SESSION['login']==1) || isset($nickname)) {

	$muzzled = false;
	// keine muzzled User
	if (file_exists("user/maulkorb.txt")) {
		$d2 = file("user/maulkorb.txt");
		foreach ($d2 as $c) {
			$part1 = explode("****",$c);
			if ($part1[0] == $nickname) {
				$muzzled = true;
			}
		}
	}

	if ($muzzled == true) {
		echo '
		<div style="margin:1em">
		<p>Du hast derzeit leider keinen Zugang zu deinem Profil.</p>
		<p><a href="logout.php" onclick="history.back()"; return false;>Zur&uuml;ck zum Chat</a></p>
		</div>
		';
		exit;
	}

	$banned = false;
	// keine banned User
	if (file_exists("user/ban.txt")) {
		$d3 = file("user/ban.txt");
		foreach ($d3 as $c) {
			$part1 = explode("****",$c);
			if ($part1[0] == $nickname) {
				$banned = true;
			}
		}
	}

	if ($banned == true) {
		echo '
		<div style="margin:1em">
		<p>Du hast derzeit leider keinen Zugang zu deinem Profil.</p>
		<p><a href="logout.php" onclick="history.back()"; return false;>Zur&uuml;ck zum Chat</a></p>
		</div>
		';
		exit;
	}

	$in_regdb = false;
	// nur registrierte User
	if (file_exists("user/user.txt")) {
		$d1 = file("user/user.txt");
		foreach ($d1 as $c) {
			$part1 = explode("****",$c);
			if ($part1[0] == $nickname) {
				$in_regdb = true;
			}
		}
	}

	if ($in_regdb !== true) {
		echo '
		<div style="margin:1em">	
		<p>Um ein Profil zu erstellen, musst du registriert sein.</p>
		<p><a href="reg.php">zur Registrierung</a></p>
		<p><a href="chat.php" onclick="history.back()"; return false;>Zur&uuml;ck zum Chat</a></p>
		</div>
		';
		exit;
	}








} else {
	echo '
		<div style="margin:1em">	
	<p>Um ein Profil zu erstellen, musst du registriert sein.</p>
	<p><a href="reg.php">zur Registrierung</a></p>
	<p><a href="chat.php" onclick="history.back(); return false;">Zur&uuml;ck zum Chat</a></p>
	</div>
	';
	exit;
}



if(!isset($_POST['action'])) {



$hobbies_old = "";
$foto_old = "";
$geschlecht_old = "";
$alter_old = "";
$wohnort_old = "";
$sternzeichen_old = "";
$mail_old = "";
$sonst_old = "";


if(file_exists("profile/$nickname")) {
    $lines = file("profile/$nickname");

    $foto_old = $lines[1];
    $foto_old = trim(str_replace(" &nbsp;","",$foto_old));

    $hobbies_old = $lines[2];
    $hobbies_old = trim(str_replace("Hobbys:&nbsp;","",$hobbies_old));

    $geschlecht_old = trim($lines[3]);

    $alter_old = $lines[4];
    $alter_old = trim(str_replace("Alter:&nbsp;","",$alter_old));

    $wohnort_old = $lines[5];
    $wohnort_old = trim(str_replace("Wohnort:&nbsp;","",$wohnort_old));

    $sternzeichen_old = $lines[6];
    $sternzeichen_old = trim(str_replace("Sternzeichen:&nbsp;","",$sternzeichen_old));

    $mail_old = $lines[7];
    $mail_old = trim(str_replace("E-Mail:&nbsp;","",$mail_old));

    // $sonst_old = $lines[8].$lines[9].$lines[10].$lines[11].$lines[12];
    $sonst_old = $lines[8];
    $sonst_old = trim(str_replace("Bemerkung:&nbsp;","",$sonst_old));

}

$filetype = "";
$source_x = "";
// include getID3() library (can be in a different directory if full path is specified)
require_once('getid3/getid3.php');



// Copy remote file locally to scan with getID3()
// $remotefilename = $foto_old;



// if ($fp_remote = fopen($remotefilename, 'rb')) {
//
//
//
//     $localtempfilename = tempnam('/tmp', 'getID3');
//     if ($fp_local = fopen($localtempfilename, 'wb')) {
//         while ($buffer = fread($fp_remote, 8192)) {
//             fwrite($fp_local, $buffer);
//         }
//         fclose($fp_local);
//
//         // Initialize getID3 engine
// 	  $getID3 = new getID3;
//
// 	  $ThisFileInfo = $getID3->analyze($localtempfilename);
//
//         $filetype = $ThisFileInfo['fileformat'];
//
//         $picsize=getimagesize("$localtempfilename");
//         $source_x = $picsize[0];
//         $source_y = $picsize[1];
//
//         // Delete temporary file
//         unlink($localtempfilename);
//     }
//     fclose($fp_remote);
//  }


// if ($source_x > 160) $source_x = 160;

if ($filetype == "jpg" || $filetype == "gif") {
$show = true;
} else {
	$foto_old = "";
}

// geuppte Fotos haben Vorrang :
$abs_path = "http://".$_SERVER['SERVER_NAME'].dirname($_SERVER['PHP_SELF']).'/';

if(file_exists('profile/'.$nickname.'.jpg')) {
	$foto_old = $abs_path.'profile/'.$nickname.'.jpg';
} elseif(file_exists('profile/'.$nickname.'.gif')) {
     $foto_old = $abs_path.'profile/'.$nickname.'.gif';
}



$foto_old = str_replace("http://profile","/profile",$foto_old);


?>



<h1>Profil von <?php echo $nickname; ?> erstellen und bearbeiten</h1>


<script>
  function end_upload3(data){
		document.getElementById('upload_3').innerHTML = data;
  }
</script>



<fieldset>

	<!-- <legend> Profil von <?php // echo $nickname; ?> </legend> -->



	<form action="upa_profil.php" method="post" enctype="multipart/form-data">
		<p>
			<label for="file" class="left">Profilbild hochladen:</label>
			<input type="file" id="file" name="file" onchange="micoxUpload2(this.form,0,'Loading ',end_upload3)"/>

			<br><span class="right">(Tipp: Am besten funktioniert ein quadratisches Bild.)</span>

			<input type="hidden" name="prof_name" value="<?php echo $nickname; ?>" />
			

		</p>
	</form>
	<div id="upload_3"></div>



	<form method='post' action='profil.php'>

<?php
if ( isset($_SERVER['HTTPS']) && strtolower($_SERVER['HTTPS']) != '' ) {
	$foto_old = str_replace("http://","https://",$foto_old);
}	


?>
				
		<img class="avatar" alt="Kein Profilbild gespeichert"  src="<?php echo $foto_old; ?>" width="160"/>

		<p>
            <input name="nick" id="nick" type="hidden" value="<?php echo $nickname; ?>" />

		<input type="hidden" name="y0" id="y0" value="<?php echo $foto_old; ?>"/><br />

		<label for="y1" class="left">Deine Hobbys: </label>
		<input name="y1" id="y1" type="text" size="40" maxlength="100" value="<?php echo $hobbies_old; ?>" /></p>
            <p class="right" style="margin-top:0;">Du bist</p>
            <p style="margin-top:0">
            <input type="radio" class="right" name="y2" id="y21" value="männlich" <?php if ($geschlecht_old == "männlich") echo 'checked="checked"' ?> /> <label for="y21">m&auml;nnlich</label><br />
            <input type="radio" class="right" name="y2" id="y22" value="weiblich" <?php if ($geschlecht_old == "weiblich") echo 'checked="checked"' ?> /> <label for="y22">weiblich</label><br />
            <input type="radio" class="right" name="y2" id="y23" value="Männlein oder Weiblein - spielt das eine Rolle?" <?php if ($geschlecht_old == "Männlein oder Weiblein - spielt das eine Rolle?") echo 'checked="checked"' ?> /> <label for="y23">Männlein oder Weiblein - spielt das eine Rolle?</label><br /><br /></p>

		<label for="y3" class="left">Dein Alter: </label>

            <select name="y3" id="y3" size="1">
            <option <?php if ($alter_old == "") echo 'selected="selected"' ?> value="">das geht keinen was an.</option>

            <option <?php if ($alter_old == "unter 16") echo 'selected="selected"' ?> value="unter 16">unter 16</option>
            <option <?php if ($alter_old == "Teeny") echo 'selected="selected"' ?> value="Teeny">Teeny</option>
            <option <?php if ($alter_old == "20 - 30") echo 'selected="selected"' ?> value="20 - 30">20-30</option>
            <option <?php if ($alter_old == "unter 40") echo 'selected="selected"' ?> value="unter 40">unter 40</option>
            <option <?php if ($alter_old == "über 40") echo 'selected="selected"' ?> value="über 40">&uuml;ber 40</option>
            <option <?php if ($alter_old == "üfü (über 50)") echo 'selected="selected"' ?> value="üfü (über 50)">&uuml;f&uuml; (&uuml;ber 50)</option>
            <option <?php if ($alter_old == "uhu (unter 100) :=)") echo 'selected="selected"' ?> value="uhu (unter 100) :=)">uhu (unter 100) :=)</option>
            </select><br />

		<label for="y31" class="left">Wohnort: </label>
		<input name="y31" id="y31" type="text" size="40" maxlength="100" value="<?php echo $wohnort_old; ?>" /><br />

		<label for="y4" class="left">Dein Sternzeichen: </label>

            <select name="y4" id="y4" size="1">

            <option <?php if ($sternzeichen_old == "") echo 'selected="selected"' ?> value="">das geht keinen was an.</option>

            <option <?php if ($sternzeichen_old == "Widder") echo 'selected="selected"' ?> value="Widder">Widder</option>
            <option <?php if ($sternzeichen_old == "Stier") echo 'selected="selected"' ?> value="Stier">Stier</option>
            <option <?php if ($sternzeichen_old == "Zwilling") echo 'selected="selected"' ?> value="Zwilling">Zwilling</option>
            <option <?php if ($sternzeichen_old == "Krebs") echo 'selected="selected"' ?> value="Krebs">Krebs</option>
            <option <?php if ($sternzeichen_old == "Löwe") echo 'selected="selected"' ?> value="Löwe">L&ouml;we</option>
            <option <?php if ($sternzeichen_old == "Jungfrau") echo 'selected="selected"' ?> value="Jungfrau">Jungfrau</option>
            <option <?php if ($sternzeichen_old == "Waage") echo 'selected="selected"' ?> value="Waage">Waage</option>
            <option <?php if ($sternzeichen_old == "Skorpion") echo 'selected="selected"' ?> value="Skorpion">Skorpion</option>
            <option <?php if ($sternzeichen_old == "Schütze") echo 'selected="selected"' ?> value="Schütze">Sch&uuml;tze</option>
            <option <?php if ($sternzeichen_old == "Steinbock") echo 'selected="selected"' ?> value="Steinbock">Steinbock</option>
            <option <?php if ($sternzeichen_old == "Wassermann") echo 'selected="selected"' ?> value="Wassermann">Wassermann</option>
            <option <?php if ($sternzeichen_old == "Fische") echo 'selected="selected"' ?> value="Fische">Fische</option>
            </select><br />


		<label for="y5" class="left">Deine <span lang="en">E-Mail</span> Adresse: </label>
		<input name="y5" id="y5" type="text" size="40" maxlength="80" value="<?php echo $mail_old; ?>"  />

            <span class="edih">
               <label for="email">Das folgende Feld muss leer bleiben (Spamschutz):</label>
               <input type="text" name="email" id="email" />
            </span><br />

		<label for="y6" class="left">Bemerkung: </label>

		<!-- <input name="y6" id="y6" type="text" size="60" maxlength="400" value="<?php echo $sonst_old; ?>" /> -->
		<textarea name="y6" id="y6" rows="4" cols="50"><?php echo $sonst_old; ?> </textarea>
		
		<br />

		<?php   echo '<input name="date" type="hidden" value="', time(), '" />'; ?>

		<br />
		<?php
		if (isset($_POST['action']) && $_POST['action']=="save") {
			echo '<p class="right" style="float: left;font-size: 2em;color: red;margin-top: 4px;margin-right: 5px;">➠</p>';
		}
		?>
		<input class="logout right"  style="font-weight:bold;" type="submit" name="action" value="Profil speichern" />


		<?php
		if (!isset($_POST['action']) || !$_POST['action']=="save") {
			echo '
				<input class="logout right"  style="font-weight:bold;"   type="button" value="Zur&uuml;ck zum Chat ohne &Auml;nderungen" onclick="javascript:self.close()" />
				';
		}
		?>


		<?php
		if (file_exists('profile/'.$nickname) || file_exists('profile/'.$nickname.'.jpg') || file_exists('profile/'.$nickname.'.gif')) {
			echo '<input class="logout right"  style="font-weight:bold;" name="delete_confirm" type="submit"  value="Profil löschen!">';
			
			if(isset($_POST['delete_confirm'])) {
				echo '<label for="delete" class="right">&nbsp;Willst du dein Profil wirklich löschen? </label>';
				echo '<input class="logout right"  style="color:red; float:left;margin-right: 1em" name="delete" id="delete" type="submit"  value="Ja, Profil löschen!">';
				echo '<input class="logout right"  style="font-weight:bold;" name="confirm_not" id="confirm_not"  type="submit"  value="Nein" >';
			}
			
			
			
		}
		?>

	</form>


</fieldset>


<?php


} elseif ($_POST['action']=="Profil speichern")  {


$geschlecht ="";

// das Loeschen von Avataren ermoeglichen:
if (strip_tags($_POST['y0']) =="kein Bild") {
	if(file_exists("profile/$nickname.jpg")) {
		unlink("profile/$nickname.jpg");
	}
	if(file_exists("profile/$nickname.gif")) {
		unlink("profile/$nickname.gif");
	}
}


$avatar = strip_tags($_POST['y0']);
$avatar = "$avatar &nbsp;"; // lustig, ohne &nbsp; geht die Bildumwandlung nicht
$hobbies = strip_tags($_POST['y1']);
if (isset($_POST['y2'])) $geschlecht = strip_tags($_POST['y2']);
$alter = strip_tags($_POST['y3']);
$wohnort = strip_tags($_POST['y31']);
$sternzeichen = strip_tags($_POST['y4']);
$mail = strip_tags($_POST['y5']);
$sonst = strip_tags($_POST['y6']);


if (isset($_POST['date']) && is_numeric($_POST['date'])) {
   $posted = intval($_POST['date']);
   $sendezeit = (time() - $posted);
   if ($sendezeit < 2 || $sendezeit > 36000) {
      die("<p>Sorry, Du warst eindeutig zu schnell mit dem Abschicken des Profils<br />Bitte geh mit der Zur&uuml;ck-Funktion Deines Browsers zur&uuml;ck und schick dein Profil erst nach einigen Sekunden ab.</p>");
   }
}


if ($_POST["email"] != "") {
   die("<p>Sorry, du hast ein Feld ausgef&uuml;llt, das leer bleiben muss. <br />Bitte geh mit der Zur&uuml;ck-Funktion Deines Browsers zur&uuml;ck und leere dieses Feld.</p>");
}



// Jetzt die Profildatei schreiben:

if (strpos($mail,"http") !== false) $mail = "";
if (strpos($mail,"www") !== false) $mail = "";

if (strpos($hobbies,"http") !== false) $hobbies = "";
if (strpos($hobbies,"www") !== false) $hobbies = "";

if (strpos($wohnort,"http") !== false) $wohnort = "";
if (strpos($wohnort,"www") !== false) $wohnort = "";

//if (strpos($sonst,"http") !== false) $sonst = "";
//if (strpos($sonst,"www") !== false) $sonst = "";



$profile_cont = "Nickname:&nbsp;$nickname
$avatar
Hobbys:&nbsp;$hobbies
$geschlecht
Alter:&nbsp;$alter
Wohnort:&nbsp;$wohnort
Sternzeichen:&nbsp;$sternzeichen
E-Mail:&nbsp;$mail
Bemerkung:&nbsp;$sonst
";


if (strlen($profile_cont) < 145) {
	echo "<br><br><br>Du hast anscheinend keinerlei Angaben in deinem Profil hinterlegt";
	echo "<br>Willst du es nochmal versuchen? Dann klick bitte <a href='profil.php'>hier</a>";
	echo "<br>Oder ohne Profil weiterchatten? Dann klick <a href='chat.php'>hier</a>";
	exit;
} else {

	$file5 = "profile/$nickname";
	$open5 = fopen($file5, "w");
	fwrite($open5,$profile_cont);
	fclose($open5);

	//Redirect zum chat:


		// $pos = strpos(strtolower($_SERVER['SERVER_SOFTWARE']), "nginx"); // Nginx Server haben mit dem redir evtl. Probleme
		// if ($pos !== false) {
		// 	echo '
		// 	<p>Profil gespeichert</p>
		// 	<p><a href="chat.php">Weiter zum Chat</a></p>
		// 	'; exit();
		// } else {
		//
		//     $uri  = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
		//     $extra1 = 'chat.php';
		//     if (isset($_SERVER['HTTP_HOST'])) {
		//
		// 	    $host  = $_SERVER['HTTP_HOST'];
		//
		// 		if ( isset($_SERVER['HTTPS']) && strtolower($_SERVER['HTTPS']) != '' ) {
		// 			header("Location: https://$host$uri/$extra1");
		// 			exit();
		// 		} else {
		// 			header("Location: http://$host$uri/$extra1");
		// 			exit();
		// 		}
		//
		//
		// 	} else {
		// 		echo '
		// 		<p>Profil gespeichert</p>
		// 		<p><a href="chat.php">Weiter zum Chat</a></p>
		// 		';exit();
		// 	}
		// }
		
		echo '<script>self.close()</script>';
		exit;
		

	} 

}

if(isset($_POST['delete'])) {
		
	unlink('profile/'.$nickname);
	unlink('profile/'.$nickname.'.jpg');
	unlink('profile/'.$nickname.'.gif');

	//Redirect zum Chat:
	// $host  = $_SERVER['HTTP_HOST'];
	// $uri  = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
	// $extra1 = 'chat.php';
	//
	// header("Location: //$host$uri/$extra1");
	// exit();

	echo '<script>self.close()</script>';
	exit;

}


?>
</body>
</html>

