<?php

// error_reporting(E_ALL);

if (phpversion() < '7.4.0') {
	echo "<p>Dieses Script erfordert PHP Version 7.4.0 oder h&ouml;her!<br >";
	echo "auf Deinem Server l&auml;uft aber PHP Version ".phpversion().".</p>";
	exit();
}

$path = '../wartung/sperren.php';
if (file_exists($path)) {
	include $path;
}

// Setup: 
if (file_exists("setup.php")) {
	
	// kritische Cookies löschen
	$chatcookies = array(
		'LoginCookie',
		'watch',
		'nick',
		'Style',
		'correct_logout'
	);

	if (isset($_SERVER['HTTP_COOKIE'])) {
	    $cookies = explode(';', $_SERVER['HTTP_COOKIE']);
	
	    foreach($cookies as $cookie) {
	        $parts = explode('=', $cookie);
	        $name = trim($parts[0]);
		
			if (in_array($name, $chatcookies) || strpos($name,'arrival') !== false) {
				unset($_COOKIE[$name]);
				$res = setcookie($name, '', time() - 3600,$install);
			}
	    }
	}
		
	// div Ordner erstellen usw.
	include ("setup.php");
}

// Setup nur einmal aufrufen:
if (file_exists("setup.php") && file_exists("admin/.htaccess")) {
	@rename("setup.php","setup.bak");
}


// .htaccess erstellen:
$baseDir = __DIR__; // Basisverzeichnis anpassen

// Verzeichnisse (z.B. smileysX, rooms, profile, upload, tn_upload)
$dirs = array_merge(
glob("$baseDir/smileys*", GLOB_ONLYDIR),
["$baseDir/rooms", "$baseDir/profile", "$baseDir/upload", "$baseDir/tn_upload"]
);

// Inhalt der .htaccess-Datei
$htaccessContent = <<<HTACCESS
<FilesMatch "\.(php|php3|php4|php5|phtml)$">
<IfModule mod_authz_core.c>
Require all denied
</IfModule>

<IfModule !mod_authz_core.c>
Deny from all
</IfModule>
</FilesMatch>
HTACCESS;

// Durch die Verzeichnisse iterieren und .htaccess nur bei Bedarf überschreiben
foreach ($dirs as $dir) {
	$htaccessFile = "$dir/.htaccess";
    
	// Wenn die .htaccess-Datei existiert und kleiner als 50 Byte ist, überschreiben
	if (file_exists($htaccessFile) && filesize($htaccessFile) < 50) {
		file_put_contents($htaccessFile, $htaccessContent);
	}
	// Wenn keine .htaccess existiert, Datei erstellen
	elseif (!file_exists($htaccessFile)) {
		file_put_contents($htaccessFile, $htaccessContent);
	}
}


$ua = $_SERVER['HTTP_USER_AGENT'];

if (strpos($ua,"NT 6.") !== false) {
	echo "<p style='color:#000;background:yellow;margin-top:1em;padding:.5em;'>Achtung! Du verwendest ein veraltetes und unsicheres Betriebssystem (Win7/8).<br >";
	echo " Damit kannst Du den Chat leider nicht mehr nutzen.</p>";
	exit();
}


// Chat zeitabhaengig offline:
if (file_exists('admin/set_offline.txt') && (!isset($ab_offen) || !isset($ab_offen))){
	$times_online = file_get_contents('admin/set_offline.txt');

	$offen = explode('-',$times_online);
	$ab_offen = trim($offen[0]);
	$bis_offen = trim($offen[1]);
}

// wg. Umlauten:
// https://stackoverflow.com/questions/25729900/ucfirst-doesnt-work-on-non-english-characters
function myucfirst($str) {
    $fc = mb_strtoupper(mb_substr($str, 0, 1));
    return $fc.mb_substr($str, 1);
}


// ini_set('session.save_path',realpath(dirname($_SERVER['DOCUMENT_ROOT']) . '/chat'));
if(!isset($_SESSION)){session_start();}

if (!isset($_SESSION['access_token'])) {
	$_SESSION['access_token'] = bin2hex(random_bytes(32));
} 

if (file_exists("redir_unwanted.php")) {
	include "redir_unwanted.php";
}	

if (file_exists("tor_test.php")) {
	include("tor_test.php");
}


	

if(isset($_SESSION['bg_img'])) {
	$bg = $_SESSION['bg_img'];
} 
elseif (is_dir("bg_img")) {  // bg_img nicht in DL
	$bg_array = []; // Initialisierung
	foreach (scandir("bg_img") as $file) {
		if ($file === ".." or $file === ".") continue;
	
		if (file_exists('login_bg_inc.php')) {
			include ('login_bg_inc.php');
		} else {
			$bg_array[] = 'bg_img/'.$file;
		}
	}

	if (isset($bg_array)) {
		$count = count($bg_array);
		$bg = $bg_array[rand(1,$count) -1]; // -1, weil array mit 0 beginnt


		// wenn bg nur täglich wechsel soll, die folgenden 3 Zeilen entkommentieren:
		
		// $daynum = date('z') + 1;
		// $r = fmod($daynum,$count) + 1;
		// $bg = $bg_array[$r];
	}
} 


else {
	$bg = 'img/helena-lopes-e3OUQGT9bWU-unsplash_1.jpg';		
}
$_SESSION["bg_img"] = $bg;



$self = dirname($_SERVER['PHP_SELF']);
if ($self == "/") {$self="";}

$base = basename($_SERVER['HTTP_HOST']);
// HTTP / HTTPS bestimmen
if (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS']!='off' or $_SERVER['SERVER_PORT']==443) {
	$prot='https://';
} else {
	$prot='http://';
}
$aufruf = $prot.$base.$self;	
	
// Besucherzähler:
$counter='visitors_'.date('Y-m-d').'.txt';

$yesterday = strtotime("yesterday");
$yd = date("Y-m-d", $yesterday);
$counter_yesterday='visitors_'.$yd.'.txt';

$dayBeforeYesterday = strtotime("yesterday -1 day");
$byd = date("Y-m-d", $dayBeforeYesterday);
$counter_beforeyesterday='visitors_'.$byd.'.txt';
if (file_exists($counter_beforeyesterday)) {unlink($counter_beforeyesterday);}

	
if (!file_exists($counter)) {
	$fp = fopen($counter,"w+");
	fwrite($fp, 0);	
	fclose($fp); 
}

$ath = "ath.txt";
if (!file_exists($ath)) {
	$fp = fopen($ath,"w+");
	fwrite($fp, 0);	
	fclose($fp); 
}

$ath_on = "ath_on.txt";
if (!file_exists($ath_on)) {
	$fp = fopen($ath_on,"w+");
	fwrite($fp, 0);	
	fclose($fp); 
}


include_once("cleanup.php");
include_once("clean_user.php");

$ua = $_SERVER['HTTP_USER_AGENT'] ?? ''; // fallback auf leeren String
if (strpos($ua,'MSIE 7.0') !== false || strpos($ua,'MSIE 8.0') !== false || strpos($ua,'MSIE 9.0') !== false) {
				
	echo "  <meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=1' ><p style='color:#ff0;background:#00f; border: 2px solid #555;padding: 0 1em 1em 1em';font-size: 13px;><br >Du verwendest einen veralteten und unsicheren Browser (Windows Internet Explorer). Die Nutzung des Chat mit diesem Browser stellt ein Sicherheitsrisiko dar, und ist aus diesem Grund leider nicht möglich. Bitte verwende einen <a style='color:#aff;background:#00f;' href='https://browsehappy.com/'>aktuellen Browser</a>, um den Chat zu nutzen.</p>";
	// exit;
}


// if(!isset($_SESSION)){session_start();} // bereits gestartet #112

if (!file_exists("user/user.txt")) {
	$text = "Gast****fe01ce2a7fbac8fafaed7c982a04e229\n";
	$dateiname = "user/user.txt";
	$handler = fOpen($dateiname , "a+");
	flock($handler, LOCK_EX);
	fWrite($handler , $text);
	flock($handler, LOCK_UN);
	fClose($handler);
}

/* BOM Warnhinweis und BOM entfernen */
$str = file_get_contents('chat_config.php');
$bom = pack("CCC", 0xef, 0xbb, 0xbf);
if (0 === strncmp($str, $bom, 3)) {
	$bom_warn = '<span style="color:red">HINWEIS: </span>Die Datei chat_config.php wurde als utf-8 mit BOM gespeichert. <br >Bitte speichere die Datei als utf-8 <span style="color:red">ohne</span> BOM!';
    echo $bom_warn."\n";
    $str = substr($str, 3);
	$config_handle = fopen("chat_config.php","w");
	fwrite($config_handle, $str);
	fclose($config_handle);
}

if (file_exists("personal_config_inc.php")) {
	$str2 = file_get_contents('personal_config_inc.php');
	$bom = pack("CCC", 0xef, 0xbb, 0xbf);
	if (0 === strncmp($str2, $bom, 3)) {
		$bom2_warn = '<br ><span style="color:red">HINWEIS: </span>Die Datei personal_config_inc.php wurde als utf-8 mit BOM gespeichert. <br >Bitte speichere die Datei als utf-8 <span style="color:red">ohne</span> BOM!';
	    echo $bom2_warn."\n";
	    $str2 = substr($str2, 3);
		$config_handle2 = fopen("personal_config_inc.php","w");
		fwrite($config_handle2, $str2);
		fclose($config_handle2);
	}
}


include("chat_config.php");


if (file_exists("clear_rooms_inc.php")) {
	include_once("clear_rooms_inc.php");
}


if (!isset($motto)) {$motto = " ";}



if (file_exists("chtver.txt")) {
	$localFile = 'chtver.txt';
	$version = trim(file_get_contents($localFile));
}

// Ghost-Status abfragen:
if (isset($_COOKIE["watch"])) {
	$watch = "on";
} else {
	$watch = "";	
}

$supporterValue = isset($supporter[0]) ? $supporter[0] : ' ';

$referrer = "";
if (isset($_SERVER['HTTP_REFERER'])) {$referrer = $_SERVER['HTTP_REFERER'];}
if (strpos($referrer,'reg.php') !== false ) {
	setcookie("online","",time()-3600);
} 

// Sprache abfragen und lang-file includen:
if (isset($_COOKIE["lang"])) {
	$lang = $_COOKIE["lang"];
} else {
      $lang = $languages[0];
}
$lang = (isset($languages) && is_array($languages) && in_array($lang, $languages)) ? $lang : "de";

$lang_file = 'lang'.strtoupper($lang).'_inc.php';
if (file_exists($lang_file)) {
	include ($lang_file);
}


if (isset($stil) && $stil <> 0) {
        $s = $stil;
} elseif (isset($_COOKIE["Style"])) {
	$s = $_COOKIE["Style"];
} else {
        $s = $default_skin;
}

if (isset($_COOKIE["schrift"])) {
	$schrift= $_COOKIE["schrift"];
} else {
	$schrift = 100;
}


if (!file_exists("user/user.txt")) {
	goodlog(); // weil nur im chat.php setup.php aufgerufen wird, um ggf.user.txt zu erstellen
}

if (file_exists("admin/mods.txt") && file_exists("admin/admin_mods.php")) {
	$mods = file("admin/mods.txt",FILE_IGNORE_NEW_LINES); 
}

setcookie('arrival', time());
setcookie('last', time());


// so kann man Optionen setzen per http://pfad-zum-chat/login.php?datum=aus&uhr=aus&sound=aus
if  (isset($_REQUEST['datum']) && $_REQUEST['datum'] == "aus") {
	setcookie("datum", "aus", time()+3600*24*30);	
}
if  (isset($_REQUEST['uhr']) && $_REQUEST['uhr'] == "aus") {
	setcookie("uhr", "aus", time()+3600*24*30);	
}
if  (isset($_REQUEST['sound']) && $_REQUEST['sound'] == "aus") {
	setcookie("sound", "aus", time()+3600*24*30);	
}


$guest_write = "";

$angemeldet = "user/user.txt";
$lines = file($angemeldet);
array_unshift($lines,"Gast****fe01ce2a7fbac8fafaed7c982a04e229"); // macht Gastlogin nur noch von $allowguest abhängig machen, auch wenn der erste User in der user.txt gelöscht wird.

$meldung = 	_LOGIN_FORM; 
$meldung1 = _LOGIN_FORM1;

$meldung2 = _LOGIN_GUEST;

$alluser[0] = ""; // sollte jemand alle User löschen


if (file_exists("admin/admins.txt") && file_exists("admin/admin_add_admins.php")) {
	$admins2 = file("admin/admins.txt",FILE_IGNORE_NEW_LINES); 
	$admins = array_merge($admins, $admins2); // und was, wenn kein $admins?
}



function goodlog() {
	global $standard, $admins, $nohello, $show_hello,$room, $ip_write, $counter, $ath, $nickname, $watch, $s, $superadmin  ;


	// Proxy erkennen
	if (file_exists("proxy_erkennen.php")) {
		include ('proxy_erkennen.php');
	}
		
	// if (file_exists("filter.php")) {include('filter.php');}
	
	if ($watch != "on") {
		$fp = fopen($counter,"r"); 
		$zahl = fgets($fp,10); 
		fclose($fp); 
		$zahl++;
	 
		$fp = fopen($counter,"w");
		fputs($fp,$zahl);
		fclose($fp);
		// echo $zahl;
		
		$fp = fopen($ath,"r");
		$high = fgets($fp,10);
		fclose($fp); 
		if ($zahl > $high) {
			$fp = fopen($ath,"w");
			fputs($fp,$zahl);
			fclose($fp);			
		} 
	}
	
	
	$host  = $_SERVER['HTTP_HOST'];

	if (isset($_SERVER['HTTP_REFERER'])) {
		$referer = parse_url($_SERVER['HTTP_REFERER']);

		$referer = $referer['host'];
			
		$host  = $_SERVER['HTTP_HOST'];
	
		if ($referer != $host) { // Eintritt mit Userübergabe nur von gleicher Domain
			echo "<h1>Userübergabe nur von gleicher Domain!"; exit;
		}

	}
	
	$uri  = rtrim(dirname(htmlspecialchars($_SERVER['PHP_SELF'])), '/\\');
	$extra = 'chat.php';
	
	$_SESSION['login'] = 1;
	
	
	// jetzt festhalten, wann und von welcher IP login.php aufgerufen wird
	$regtime = time()."****".$_SERVER['REMOTE_ADDR']."\n";

	$file8 = 'user/user_login.txt';	
	
	$lines = file($file8);
	foreach ($lines as $line_num => $line) { // aelter als 1 h loeschen
		$part = explode("****",$line);
		if ((time() - $part[0]) < 60*60 && $ip_write === true) {
			$regtime .= $line;
		}
	}
	
	$open8 = fopen($file8, "w");
	fwrite($open8,$regtime);
	fclose($open8);
	
	// Die Eintrittsmeldung
	if (file_exists('profile/'.$_SESSION["chatuser"].'.jpg')) {
		$prof_link ='<span class="av_link"><a href="popprof.php?profil='.$_SESSION["chatuser"].'" onclick="ProfilOeffnen(this.href); return false;" title="Profil von '.$_SESSION["chatuser"].' anschauen (Popup)"  > <img class="av" src="profile/'.$_SESSION["chatuser"].'.jpg" alt="" height="32"></a></span>';
	} elseif (file_exists('profile/'.$_SESSION["chatuser"].'.gif')) {
		$prof_link ='<span class="av_link"><a href="popprof.php?profil='.$_SESSION["chatuser"].'" onclick="ProfilOeffnen(this.href); return false;" title="Profil von '.$_SESSION["chatuser"].' anschauen (Popup)"  > <img class="av" src="profile/'.$_SESSION["chatuser"].'.gif" alt="" height="32"></a></span>';		
	} else {
		$prof_link = "";
	}

	if (file_exists('ip_inc.php')) {
		include ('ip_inc.php');
	} else {
		$ip_login = '</span> <span class="ip">'.$_SERVER['REMOTE_ADDR'].'</span>';
	}
		
	$herein ='<p><span class="dt">'.date("d\.m\.").'</span> <span class="uz">'.date("H:i:s").'</span><span class="tr"> | </span>'.$prof_link.' <span class="hello" oncontextmenu="ads(\'/erase '.date("H:i:s").'\'); return false;" onclick="ads(\'\u0040'.$_SESSION["chatuser"].'\'); return false; "  title ="'.date("d\.m\. H:i:s").'" style="color:#888; font-weight:bold; cursor: pointer">['.$_SESSION["chatuser"].'</span>  <span class="hello">'._NEWUSER.'] </span> </span> '.$ip_login.'</p>'.PHP_EOL;	


	// wenn Admin als User reingeht:
	if (!in_array($_SESSION["chatuser"], $admins)) {
		setcookie ("watch", "", time() - 3600);		
	}

		
	if (!in_array($_SESSION["chatuser"], $admins) || ($watch !== "on"  && $nohello !== true) && $show_hello == "yes")  {
		
		$file5 = 'rooms/'.$standard;
		$open5 = fopen($file5, "a");
		fwrite($open5,$herein);
		fclose($open5);
	}

	if (file_exists("telegram_bot.php")) {
		if (!in_array($_SESSION["chatuser"], $admins)) {	
			include("telegram_bot.php");
		}
	}

	// if (file_exists("mail2sms.php")) {
	// 	if (!in_array($_SESSION["chatuser"], $admins)) {
	// 		include("mail2sms.php");
	// 	}
	// }
	
	if (isset($_COOKIE["img_size"])) {
		$img= $_COOKIE["img_size"];
	} else {
		$img = "not_set";
	}
	
	
	// Statistik Skin erstellen - außer superadmin:		
	if (file_exists('skincount.txt') && isset($superadmin)) {
		if (!in_array(trim($_SESSION["chatuser"]), $superadmin)) {

			if ($s <= 9) {$n = " ".$s;} else { 
				$n = $s;
			} 
			$skincount = $n." +++ ".date("d.m.Y H:i:s")." *** ".$_SESSION["chatuser"]." --- img_size: ".$img."\n";
			$handle = fopen ("skincount.txt", "a");
			fwrite ($handle, $skincount);
			fclose ($handle);
		}
	}
	
		
	// Redirect zum Chat:
	header("Location: //$host$uri/$extra");
	exit();
}


// Max. Anzahl User beim Login abfangen
$all_users = 0;
$user1=0;
$userdir = 'user/';
if ($handle = opendir($userdir)) {
	// Das ist der korrekte Weg, ein Verzeichnis zu durchlaufen:
	while (false !== ($file = readdir($handle))) {
		if(strpos($file,"p_") == 1){
			$user1 = count(file($userdir.$file));
			$all_users += $user1; 
		}
	}
	closedir($handle);
}


if (isset($maxuser) && $all_users >= $maxuser) {
    echo '<h1>('.$all_users.') Maximale Anzahl User im Chat erreicht - please try later';
    exit;
}



// cookie nick holen fuer ban und maulkorb:
$nickname ="";
if (isset($_COOKIE["nick"])) {
	$nickname = htmlEntities($_COOKIE["nick"], ENT_QUOTES);
}


// kein Login fuer gebannte nickname oder IP

if (file_exists("user/ban.txt")) {
	$banned = file("user/ban.txt");
	foreach ($banned as $c) {
		$part1 = explode("****",$c);
		$part2 = explode("#*#*",$part1[1]);
		if (strlen($c) > 1 && $part2[0] > time()) {
			$rip = $_SERVER['REMOTE_ADDR'];

      		if ($part1[0] == $nickname || (trim($rip) == trim($part2[1]) ))  {
				echo "<h1>You're banished";
				exit();
			}
		}
	}
}


// nur alle $guest_login_block_time ein login zulassen
$closed = 0;
if (!isset($guest_login_block_time)) {$guest_login_block_time = 60; }
$reg_closed = false;

if (isset($_POST['username'])) {
	$uebernahme = htmlspecialchars($_POST['username']);
}


if (isset($uebernahme)) {$reg_closed = false;}
elseif (file_exists("user/user_login.txt")) {
	$prev_reg = file("user/user_login.txt");
	foreach ($prev_reg as $c) {
		$part = explode("****",$c);
		$frei = time() - $part[0];

		if (strlen($c) > 1 && $frei < $guest_login_block_time) {
			$rip = $_SERVER['REMOTE_ADDR'];

			$closed = $guest_login_block_time-$frei; 

			if (trim($rip) == trim($part[1])) {
			
			        $meldung2 = '<span>'._LOG_FORM.'<span aria-live="polite" aria-relevant="all"  id="countdwn"></span></span>';

					// if(file_exists('nopw.php') && isset($nopw) && $nopw == true ) {
					$meldung= $meldung2;
					// }
				$reg_closed = true;
			}
		}
	}
}



//session_start();
$_SESSION['login'] = 0;
unset($_SESSION['chatuser']);


// nick per POST oder GET Parameter übernehmen, z.B. aus einem Forum:
// if (isset($_POST['username']) || isset($_GET['username']) && isset($maxuser) && $user1 < $maxuser) {
// oder, wem GET zu unsicher erscheint, dann folgenden Code:
// GET ist vor allem erforderlich, um den Chat in einem Popup zu öffen
if (isset($_POST['username']) && isset($maxuser) && $user1 < $maxuser) {
    // Parameter säubern:
    
		
    if (isset($_POST['username']))    $uebernahme = htmlspecialchars(trim($_POST['username']));
    if (isset($_GET['username']))    $uebernahme = htmlspecialchars(trim($_GET['username']));
    $uebernahme = str_replace(" ","_", $uebernahme);
	
    if (isset($_POST['room']))    $room = htmlspecialchars($_POST['room']);

	
    // Prüfung auf erlaubte usernames:
    if ($uebernahme == "")  { // wenn übergebener Nick leer, d.h. User nicht im Forum registriert
            $meldung = '<span style="color:red;font-weight:bold;">'._LOGIN_FORM_FORUM1.'</span>';
	

    } elseif (in_array(strtolower($uebernahme), $nicknotallowed))  { // andere verbotene Nicks (chat_config.php)
        $meldung = '<span style="color:red;font-weight:bold;">'._LOGIN_FORM_FORUM3.'</span>';

	} elseif (preg_match("/:|;|,|\.|%|\"|<|>|\?|\/|&| |\+|\*|@|'/",$uebernahme)) {
        $meldung = '<span style="color:red;font-weight:bold;">'._LOGIN_FORM_FORUM4.'</span>';

	} elseif ($reg_closed == true) {
        // do nothing $meldung = '<span style="color:red;font-weight:bold;">'._LOG_FORM.'</span>';

	} elseif (in_array($uebernahme, $admins)) {
        // do nothing $meldung = '<span style="color:red;font-weight:bold;">Admin-Login</span>';

	} elseif (in_array($uebernahme, $mods)) {
        // do nothing $meldung = '<span style="color:red;font-weight:bold;">Mod-Login</span>';


    } else {
			$_SESSION['chatuser'] = $uebernahme;
			setcookie("nick",$uebernahme, time()+86400*30); // nick cookie speichern fuer ban
			goodlog();
    }
}

// $nopass = false;
// if (isset($nopw) && $nopw === true && file_exists("nopw.php")) {$nopass = true;}
    
if (isset($_POST['regname'])) {  // wenn login abgeschickt
$regname = htmlspecialchars(trim($_POST['regname'], " \t\n\r\0\x0B\xC2\xA0")); // das fehlte noch


if ($nickgross === true) {
	$regname = myucfirst(str_replace(" ","_",$regname));
} else {
	$regname = str_replace(" ","_",$regname);
}


// /ghost cookie setzen bei login
if (strpos($regname,"/g") !== false) {
	$regname = str_replace("_","", $regname); // /ghost gilt mit und ohne Leerzeichen
	$ghostcheck = str_replace("/ghost","", $regname);
	$ghostcheck = str_replace("/g","", $ghostcheck); // /ghost oder /g möglich
	if (in_array($ghostcheck, $admins)) {
		$Gueltigkeit = time()+86400*360;	// cookie gilt 360 Tage
		setcookie("watch", "on", $Gueltigkeit);
		$regname = $ghostcheck;
		$nohello = true;
	}
}

	// if ($allowguest != "yes" && $regname == "Gast") {
	// 	echo "<h1>No Guests allowed"; // wenn jmd trotz ausgeblendetem Gast-Login Gast/demo eingibt
	// 	exit();
	// }


	// Zugang ohne Registrierung, aber mit Name:

	// if ($_POST['pass'] =='' && $nopass === true) {
	if ($_POST['pass'] =='') {
		include("nopw.php");
	} else { // wenn Nickname und PW übereinstimmen:
		foreach ($lines as $line_num => $line) {
			if(strpos($line,"****") !== false) {
				$reguser = explode("****",$line);
				$regged = trim($reguser[1]);

				if (trim($reguser[0]) != "") {
					// if (trim($reguser[0]) == $regname && $regged == md5($_POST['password'])) {
					if (trim($reguser[0]) == $regname && ($regged == md5($_POST['pass']) || password_verify($_POST['pass'],$regged))) {	
					
							// Gaeste durchnummerieren:
							if ($regname == "Gast") {
								
								$gast = "user/gast.txt";
								if (file_exists($gast)) {
									$gastnr = file($gast);
									$gastnr = $gastnr[0] +1;
								} else {
									$gastnr = 100;
								}

								$open3 = fopen($gast, "w");
								flock($open3,LOCK_EX);
								fwrite($open3,"$gastnr");
								flock($open3,LOCK_UN);
								fclose($open3);
								$reguser[0] .= '_'.$gastnr;
								$_SESSION['chatuser'] = $reguser[0];
								setcookie("nick",$reguser[0], time()+86400*30); // nick cookie speichern fuer ban
						
						
							} else {
								$_SESSION['chatuser'] = $reguser[0];
								setcookie("nick",$reguser[0], time()+86400*30); // nick cookie speichern fuer ban
							
							}

							if ($reg_closed == true && $regname == "Gast") {
								// do nothing $meldung = '<span style="color:red;font-weight:bold;">'._LOG_FORM.'</span>';
							} else {	
								goodlog();
							}						
				
						// } elseif (trim($reguser[0]) == $regname && $regged != md5($_POST['password'])) {
						} elseif (trim($reguser[0]) == $regname && ($regged != md5($_POST['pass']) && !password_verify($_POST['pass'],$regged,))) {
							$meldung = '<span style="color:red;font-weight:bold;">'._LOGIN_FORM2.'</span>';
						}
					}
				}
			}
		}
	}	
	
	


$host = $_SERVER['HTTP_HOST'];
preg_match("/[^\.\/]+\.[^\.\/]+$/", $host, $matches);

if (!isset($description)) {$description = "Unser Chat";}

?>


<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="<?php echo $lang; ?>" lang="<?php echo $lang;?>">
<head>
<meta http-equiv="content-type" content="text/html;charset=utf-8" >
<meta name="description" content="<?php echo $description; ?>" >
<meta name="keywords" content="@bots: please look for keywords in document body ;-)" >
<meta name="author" content="Dipl.-Ing.(FH) F. Weisshart" >
<meta name="generator" content="notepad ;-)" >
<meta name="robots" content="index, nofollow" >
<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=yes" >

<title><?php echo $matches[0]; ?> Chat Login</title>


<link rel="shortcut icon" href="img/favicon.ico">
<link rel="apple-touch-icon" sizes="57x57" href="img/apple-touch-icon-57x57.png">
<link rel="apple-touch-icon" sizes="114x114" href="img/apple-touch-icon-114x114.png">
<link rel="apple-touch-icon" sizes="72x72" href="img/apple-touch-icon-72x72.png">
<link rel="apple-touch-icon" sizes="144x144" href="img/apple-touch-icon-144x144.png">
<link rel="apple-touch-icon" sizes="60x60" href="img/apple-touch-icon-60x60.png">
<link rel="apple-touch-icon" sizes="120x120" href="img/apple-touch-icon-120x120.png">
<link rel="apple-touch-icon" sizes="76x76" href="img/apple-touch-icon-76x76.png">
<link rel="apple-touch-icon" sizes="152x152" href="img/apple-touch-icon-152x152.png">
<link rel="icon" type="image/png" href="img/favicon-196x196.png" sizes="196x196">
<link rel="icon" type="image/png" href="img/favicon-160x160.png" sizes="160x160">
<link rel="icon" type="image/png" href="img/favicon-96x96.png" sizes="96x96">
<link rel="icon" type="image/png" href="img/favicon-16x16.png" sizes="16x16">
<link rel="icon" type="image/png" href="img/favicon-32x32.png" sizes="32x32">
<meta name="msapplication-TileColor" content="#ffc40d">
<meta name="msapplication-TileImage" content="img/mstile-144x144.png">
<meta name="msapplication-config" content="img/browserconfig.xml">

<!-- <link rel="stylesheet" type="text/css" media="screen" href="login.css?<?php echo filemtime('login.css') ?>" > -->

<script>if (top != self) {top.location = self.location;}</script>

<script src="anw_anz_noonload.js"></script>

<script>
	
	// Prüfen, ob Cookie color fehlt
	if (document.cookie.indexOf('color=') === -1) {
		// Wert aus localStorage nehmen
		let wert = localStorage.getItem('color');
		if (wert) {
			// Cookie wiederherstellen
			document.cookie = "color=" + wert + "; path=/; max-age=" + (60 * 60 * 24 * 30);
		}
	}
	
// /ghost cookie löschen bei login
function delCookie() {
	let nick = document.forms["login"]["regname"].value;
	if (nick.indexOf('nog') != -1) {
		let pos = nick.indexOf('/');
		let cleannick = (pos !== -1) ? nick.substring(0, pos) : nick; // Kürze den String ab dem ersten Leerzeichen
		document.forms['login']['regname'].value = cleannick.trim();
		document.cookie = "watch= ; expires = Thu, 01 Jan 1970 00:00:00 GMT";
		location.reload();
		return false;
	}
}

function validateInput() {
	const input = document.getElementById("regname").value;

	// Erlaubte Zeichen: Alle Buchstaben (inkl. Umlaute und ß), Ziffern, Unterstrich und Slash
	// Leerzeichen und Emojis sind ausgeschlossen
	const regex = /[^a-zA-ZäöüÄÖÜß0-9_/ ]/;

	if (input.includes(" /g") || input.includes(" /n") ) {
		return true;
	}

	if (regex.test(input)) {
		alert("Unerlaubte Zeichen gefunden! Bitte nur Buchstaben, Ziffern und den Unterstrich.");
		return false; // Verhindert das Absenden des Formulars
	}
	// return true; // Eingabe ist gültig
}


var zeit = <?php echo $closed; ?>;      

function ZeitAnzeigen() {
if (document.getElementById('countdwn')) {
	if (zeit >= 1) {
		document.getElementsByTagName('legend')[0].style.color="red";
		document.getElementById('countdwn').innerHTML = 'in&nbsp;' + zeit + '<?php echo _SEC; ?>';
		zeit = zeit - 1;
		setTimeout("ZeitAnzeigen()", 1000);
	}
	else {
		document.getElementsByTagName('legend')[0].style.color="green";
		document.getElementById('countdwn').innerHTML = '';
	}
}
}

document.getElementsByTagName("html")[0].style.opacity = 0;
window.onload = function () {
	document.getElementsByTagName('html')[0].style.opacity = 1;
	document.getElementsByTagName('html')[0].style.WebkitTransition = 'opacity 300ms';
	document.getElementsByTagName('html')[0].style.Transition = 'opacity 300ms';
}




</script>

<style>
	

	html,body,div,p,h1,h2,h3,h4,h5,ul,ol,span,form,img,li {
		font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
		border:0;
		margin:0;
		padding:0;
	}

	html {padding: 1em;}

	body {
		font-size:100.01%;
		text-align:center;
		margin:auto;
		-webkit-text-size-adjust: none;
		background:#ddd;
	}

	fieldset{margin:1em auto;}

	h1, h2, h3 {color:#555;}

	h2 {
		margin-bottom:1em;
	}

	p, label, input, legend {
		font-size:14px;
		margin: .3em 0;
	}

	/*@media only screen and (max-width:680px) {
		input{font-size:16px;}
	}
	*/
	p {font-size:.9em; margin:0 5px;}

	/*a:link, a:visited {}
	a:focus, a:hover {color:black !important;background:#eee !important;text-shadow: 0 0 black !important;}
	*/

	legend {
		padding: .5em 1.5em;
		color: #555;
		border-radius: 5px;
		max-width: 22em;
		font-weight:bold;
		margin:auto;
		background: #ddd;
		border: 1px solid #222;
	}


	label.left {
	 float: left;
	 text-align: right;
	 width: 7em;
	 padding: .4em 1em .1em 0;
	 margin-right: .5em;
	}


	input[type="submit"] {
	/*-webkit-appearance: none;
	-moz-appearance: none;
	appearance: none;
	*/
	border-radius:2em;
	border:1px solid #222;
	background-color: #eee;
	color:#222;
	}

	input.right {width: 95%; height:2.5em;}

	input.right:hover, 
	input.right:focus,
	input.right:active {
	cursor:pointer;
	background:#fff;
	}


	form br {
	 clear: both;
	}

	.lnk, .dot, dfn {
	position:absolute;
	left:-1000px;
	top:-1000px;
	width:0;
	height:0;
	overflow:hidden;
	display:inline;
	}


	#preload img{
	height: 1px;
	visibility:hidden;
	}

	#nur_lesen {font-weight:bold; color: red;}

	.flag { margin: 0 5px 0 0;}

	fieldset {
	/* margin-top:2em; */
	width: 21em;
	max-width:80vw;
	padding: .1em .1em .5em .1em;
	border: 1px solid;
	}



	#merken {
		width: 1em;
		height: 1em;
		border: 0;
		padding: 0;
	/*	margin-left:5.2em;*/
		background-color: transparent;
	}


		:root {
		  --bg: rgba(235,235,235,0.7);
		}	
	
	#logo:has(video), #logo:has(div) {display: none;}	
	video, #logo > div {display:none;} /*weil firefox :has() nicht unterstützt*/
	
	a.datenschutz{color:#fff;}
	a:hover.datenschutz, a:focus.datenschutz {color:#fff;background:transparent;text-decoration:none;}
	#output {font-size: 0.8em !important;}
	#output li {list-style-type:none;}
	.sr {
	      position:absolute;
	      left:-1000px;
	      top:-1000px;
	      width:0;
	      height:0;
	      overflow:hidden;
	      display:inline;
	}

	input {
		width:14.8em;
		line-height: 23px;
	}

	#rules, .stats, fieldset {
		background: var(--bg);
		margin:1em auto;
		border:1px solid;
		border-radius:4px;
		padding: 1em;
	}

	#rules p {
		background:transparent;
	}


	fieldset {width:unset;}


	.stats {line-height:1.5em;font-size:.8em;}


	#rules, fieldset, .stats {
		max-width: 22em;
		margin: 1em auto .5em;
		border-radius: 1em;	
		text-align:left;
	}


	@media only screen and (min-width: 500px) {


		section, #main {
			background: var(--bg);
			padding: 5px;
			width: 25rem;
			margin: auto;
			border-radius: 6px;
		}

	
	}

	@media only screen and (max-width: 500px) {
		html {padding:.2em 1em 1em 1em;}
	
		body:after {
			background-size: cover;
		}
		legend {
			width: 85%;
		}
		input {
			font-size:16px;
			width:95%;
		}
		#merken {
	/*		margin-left:1em;*/
		}	
		label.left {
			float: none;
		}
		#kopf {
			margin: 1em auto;
		}
		#reload, #stats_preview {
			opacity:1 !important;
			color: #fff !important;
			text-shadow: black 0.1em 0.1em 0.2em !important;
		}
	}

	
	@font-face {
		font-family: 'Architects';
		src: url('architects-daughter-v11-latin-regular.woff');
		font-display: swap;
	}

	#reload {
		opacity:.8;
		font-size:1rem;
		text-align: left;
		display:block;
		visibility:hidden;
	}
	#reload a {
		text-decoration:none;
	}

	h1 {
		font-size: 1.5em;
		margin: 10px auto;
		display: inline-block;
		padding: 5px 10px;
		color: white;
		background-image: linear-gradient(90deg,#7a7afb,red,yellow,green,#ca4aca);
		-webkit-background-clip: text;
		-webkit-text-fill-color: transparent;
		-webkit-text-stroke: 1px #000;
	}

	h2 {
		display:block;
		margin: 0 1em 1em;
		font-size: 1.4em !important;
		font-family: "Architects", cursive;
		line-height:1.6em;
		color: #ffdc00; 
		text-shadow: #000 0.1em 0.1em 0.2em		
	}


	<?php
	if ($s == 14 || $s == 7 ) {
	echo '
		
		body:after {
			content: "";
			position: fixed;
			top: 0;
			height: 100vh;
			left: 0;
			right: 0;
			z-index: -1;
			background: url("'.$bg.'") center center;		
			background-size: cover;
		}
	

	
		#kopf {
		    background: var(--bg);
		    padding: 5px;
		    width: fit-content;
		    margin: auto;
		    border-radius: 6px;
		    margin-bottom: .5em;
		}
		
		#reload {visibility:visible;}
	
	';
	}
	

	if (isset($login_background)) {
		echo 'body:after{background:'.$login_background.'}';
	}

	if ($s == 4 || $s == 5 || $s == 9 || $s == 11 || $s == 12 || $s == 15) {
		echo '
		html {filter: invert(1);}
		.flag, h1, h2, legend span {filter: invert(1);}
		fieldset p {filter: invert(1);}
		#countdwn {filter:invert(0);}
		';
	}

	?>
	
	h3 {font-size:.9em;}
	
	#ssl {font-size: .7em;}
	.stats {display:none;}

	#main {
		opacity:0;
	    animation-name: einblenden;
	    animation-duration: 2s;
	    animation-delay: .5s;
		animation-fill-mode: forwards; 
		position:relative;
	}
	
	@keyframes einblenden {
	    from { opacity:0; }
	    to { opacity:1; }
	}

	
	#stats_preview {
		opacity:.25;
		font-size:9px;
		cursor:pointer;
		position: absolute; left: 85%; bottom:1em;
	}
	
	<?php
	if ($s == 7 ) {
		echo '	#ssl, .prob, .prob a {color: #fff !important; text-shadow: black 0.1em 0.1em 0.2em !important;}	';
		echo '#reload {position:absolut;left:0;bottom:0;z-index:15;}';
		echo '#footerlink {position:static !important;text-align:center !important;}';
	}
	if ($s != 7 ) {
		 echo '	.mob_only {display:none;}	';
	}
	
	?>
	
	#password, #label_password, .guest_reg_hinweis {display:none;}
	
	#noch {display:block;margin:1em;}
		
</style>

<?php
	
if (isset ($_COOKIE["enable_dark"]) && $_COOKIE["enable_dark"] != "1") {
	echo'	
<style>
	/* damit dunkle Firefox-Themes die Skins nicht zerschießen */
	@supports not  (-moz-appearance:none) { 
		@media (prefers-color-scheme: dark) {
				html,h1,h2{filter:invert(1)}
				body::after{filter:invert(1)}
		}
	}
	</style>
	';
}
?>

<?php
// damit ist 1Password autofill möglich
if (isset($_COOKIE['watch']) || isset($_COOKIE['listen']) || isset($_COOKIE['showip'])) {
	echo '
		<style>#password, #label_password {display:block;}</style>
		';
	}
?>


</head>
<body>
<!-- <section role="main"> -->
<?php 
echo "<!-- Info: Server = ".$_SERVER['SERVER_SOFTWARE']." - Chat-Version: ".$version." - PHP-Version: ".phpversion()." -->"; 
?>



<div id="kopf">

<!-- die folgende Zeile ist nur fuer die Demo, und kann ohne Folgen geloescht oder auch belassen werden: -->
<!-- Wer will, kann hier ein eigenes Logo einbinden -->
<?php if(file_exists("wdw_inc.php") && $s != 12 && $s != 7 ) {
	echo '<div id="logo" style="margin:auto; height:55px; max-width: 200px; padding: 5px 10px">';
	include ("wdw_inc.php"); 
	echo '</div>';
}

if (file_exists("header_inc.php")) include("header_inc.php");

if ($titel != "") {
   echo "<h1>$titel</h1>";
}
if ($motto != "") {
   echo "<h2>$motto</h2>";
}

if (!file_exists("rooms/Offline")) {
	echo '<span id="noch"></span>';
} else {
	echo '<h3 style="display:block;margin:-1em 0 1em 0;font-weight:bold;text-shadow: 0.6px 0.6px 0.6px white, 0.6px -0.6px 0.6px white, -0.6px 0.6px 0.6px white, -0.6px -0.6px 0.6px white;" >Dieser Chatraum ist vorübergehend geschlossen.<br>This chat room is temporarily closed.</h3>';
}

?>

</div>
<div id="main" role="main">

<?php
// if ($s != 12 && $s != 7 ) {
// 	echo '<p class="sr">Hinweis für sehbehinderte User: Der folgende Link  öffnet den Chat mit dem Skin BF-Linear. Dieser Skin ist speziell für sehbehinderte Chatter optimiert: Gelbe Schrift auf blauem Hintergrund, Schrift stark vergrößerbar, Eingabefeld oben usw. <a href="'.$self.'/chat-bf.php">'.$aufruf.'/chat-bf.php</a>
// <br>Achtung! Dieser Skin bleibt gespeichert, auch wenn der Chat neu aufgerufen wird.
// Verlassen dieses Skins mit dem Dropdown-Menü "Seitenstil" unter Optionen.</p>';
//
// } else {
// 	// echo '<p class="sr">Dies ist der Zugang für sehbehinderte oder blinde User</p>';
// }
?>



<?php if(file_exists("lang_switcher_inc.php")) {include("lang_switcher_inc.php");} ?>



<form method="post" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']);?>" id="login" onsubmit="delCookie(); return validateInput()">
<fieldset style="position:relative">


<legend id="first_legend"><?php echo $meldung; ?></legend>
	
<button type="button" aria-label="Passwort anzeigen" onclick="toggle_password()" style="background: none; border: none; padding: 0; cursor: pointer;position:absolute; left:10px;top:0; opacity: .3;">
	<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
		<path d="M1 12C1 12 5 4 12 4C19 4 23 12 23 12C23 12 19 20 12 20C5 20 1 12 1 12Z" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
		<circle cx="12" cy="12" r="3" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
	</svg>
</button>
	
	
<?php

// if ($nopass === true) {$allowguest = "no"; }

	
// korrekten Logout abfragen:
if (isset($_COOKIE["correct_logout"])) {
	if ($_COOKIE["correct_logout"] === "0") {
		echo '<p style="font-size:.8em;color:#222;border:1px solid;padding:5px;margin-bottom:1em;background:yellow;">'. _CORRECT_LOGOUT .'</p>';
	}
}
	
?>	
	
	


<label for="regname" class="left">
	
<?php 
if ($watch == "on") {echo '<svg style="opacity: .5;margin-bottom:-2px" width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-labelledby="ghostAltTitle" role="img">
    <title id="ghostAltTitle">/ghost aktiviert</title>
    <path d="M12 2C8 2 5 5 5 9V21C5 21 6.5 20 8 21C9.5 22 10.5 20 12 21C13.5 22 14.5 20 16 21C17.5 22 19 21 19 21V9C19 5 16 2 12 2Z" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    <circle cx="9" cy="10" r="1.5" fill="black"/>
    <circle cx="15" cy="10" r="1.5" fill="black"/>
    <path d="M10 14C10.5 14.5 11.5 14.5 12 14.5C12.5 14.5 13.5 14.5 14 14" stroke="black" stroke-width="2" stroke-linecap="round"/>
  </svg> ';}
echo _LOGIN_GUEST2; 
?>
</label>

<!-- <input type="text" size="20" maxlength="20" id="regname" name="regname" value="<?php if(isset($nickname) && strpos($nickname,'Gast') === false && isset($ppp) ) {echo $nickname;} if ($watch == "on" && isset($ppp)) {echo " /ghost";} ?>"  ="off" oninput="lookup_reg()" > -->

<!-- <input type="text" size="20" maxlength="20" id="regname" name="regname"  autocomplete="on" value="<?php if(isset($nickname)  && strpos($nickname,'Gast') === false ) {echo $nickname;}  ?>" oninput="lookup_reg()" > -->

<input type="text" size="20" maxlength="20" id="regname" name="regname"  autocomplete="on"  oninput="lookup_reg()" >

<br >

<label for="password" id="label_password" class="left"><?php echo _LOGIN_GUEST3; ?> </label>
<!-- <input type="password" id="password" name="password"  value="<?php if(isset($ppp)) echo $ppp; ?>" placeholder="Gäste: dieses Feld leer lassen"> -->
<input type="password" id="password" name="pass" autocomplete="new-password" placeholder="Gäste: dieses Feld leer lassen">

<!-- <input type="checkbox" id="merken" name="merken" <?php if (isset($ppp)) echo "checked='checked'"; ?>><label for="merken" id="merken_label" style="font-size:.8em;"> <?php echo _LOGIN_FORM4; ?></label> -->


<br>
<?php
if(file_exists("nutzungsbedingungen.php")) {
	if (isset($_COOKIE["nick"]) && strpos($_COOKIE["nick"],"Gast") === false ) {
			echo'<input type="checkbox" id="nutzung" required style="width:unset" checked>';
		} else {
			echo'<input type="checkbox" id="nutzung" required style="width:unset" >';
		}
		
		echo'
			<label for="nutzung" style="font-size:.8em;" >Ich habe die <a href="nutzungsbedingungen.php" rel="noreferrer" target="_blank">Nutzungsbedingungen</a> gelesen. Mit&nbsp;dem Betreten des Chat erkenne ich diese an.</label>
			<br><br>	
		';
}

if (isset($mindestalter)) {
	echo '		<span style="font-weight:bold; color:red">Chat ab '.$mindestalter.' Jahre!</span>  <br>';
	if (isset($_COOKIE["nick"]) && strpos($_COOKIE["nick"],"Gast") === false ) {
		echo'<input type="checkbox" id="mind_alt" required style="width:unset" checked>';
	} else {
		echo'<input type="checkbox" id="mind_alt" required style="width:unset" >';
	}
	
	echo'
		<label for="mind_alt" style="font-size:.8em;" >Mit dem Betreten des Chat bestätige ich, dass ich mindestens '.$mindestalter.' Jahre alt bin.</label>
	<br><br>	
	';
}


?>

<input type="submit" class="right" id="send" value="Login" >

<p style="text-align:left;">
</p>

</fieldset>
</form>


<p id="noscript" style="color:red; font-weight:bold;"><br >Zur Benutzung des Chat muss Javascript aktiviert sein.<br ><br ></p>
<script> document.getElementById("noscript").style.display="none";	</script>


<?php
echo '<p class="lnk"><a href="//webdesign.weisshart.de">Chat by webdesign weisshart</a></p>';
?>


<?php

if (file_exists("login_inc.php")) {
	include "login_inc.php";
}



if (isset($show_user) && $show_user == "yes") {
	echo '<p class="stats"><span id="user_online"></span>
		<!-- <br>(max.&nbsp;zulässig&nbsp;'.$maxuser.') -->
	';

	if (file_exists("ath_on.txt")) {
		$fp = fopen("ath_on.txt","r"); 
		$ath_on = fgets($fp,10); 
		fclose($fp);
	
		$ath_time = date('d.m.Y H:m \U\h\r', filemtime("ath_on.txt"));	
		echo '<br>ATH: '.$ath_on.' User gleichzeitig online am <span style="white-space: nowrap;">'.$ath_time.'</span>';
	}
	

	if (file_exists($counter)) {
		$fp = fopen($counter,"r"); 
		$heute = fgets($fp,10); 
		fclose($fp); 
	}

	if (file_exists($counter_yesterday)) {
		$fp = fopen($counter_yesterday,"r"); 
		$gestern = fgets($fp,10); 
		fclose($fp); 
	}

	if (file_exists($ath)) {
		$fp = fopen($ath,"r"); 
		$ath = fgets($fp,10); 
		fclose($fp); 
		$ath_alltime = date('d.m.Y ', filemtime("ath.txt"));	
		$ath_all = '<br>ATH: '.$ath.' Logins am '.$ath_alltime;
		
	}

	if (isset($heute) && isset($gestern) && isset($ath)) {
		echo "\n";
		// echo '<br>Logins heute: <span id="online_today"></span>, gestern: '.$gestern.' '.$ath_all;
		echo '<br>Logins heute: <span id="online_today"></span>, gestern: '.$gestern;
	}

	echo '</p>';
}


if (!isset($_SERVER['HTTPS']) || $_SERVER['HTTPS'] != 'on') {
echo '
<p  id="ssl">Über eine <a href="https://'.htmlspecialchars($_SERVER["HTTP_HOST"].$_SERVER["PHP_SELF"]).'">geschützte (verschlüsselte) SSL/TLS Verbindung</a> chatten.</p>
';
} else {
echo '
	<p  id="ssl">&#x1F512;&nbsp;Transportverschlüsselung (SSL/TLS) aktiviert ✔︎</p>
';
}

// echo $_SERVER['HTTP_REFERER'];
if (file_exists("clean_cookies.php")) {
	echo '<p class="prob" style="font-size:.8em;margin-top:1em;">Probleme? ▶︎ <a href="clean_cookies.php">Login bereinigen</a></p>';
}

echo '<p id="reload"><a title="Hintergrundbild wechseln" href="reload_bg_img.php">✻</a>';

echo '<div id="stats_preview">';
echo '<p onclick="show_stats();" >';
include "anw_anz.php";
echo ' / <span id="online_today2"></span> / '.$gestern.'</p>';

echo '</div>';



?>


</div>



<script>
	
function toggle_password() {
	if (getComputedStyle(document.getElementById('password')).display !== 'none') {
	// if (document.getElementById('password').style.display == "block" ) {
		document.getElementById('password').style.display='none';
		document.getElementById('label_password').style.display='none';	
	} else {
		document.getElementById('password').style.display='block';		
		document.getElementById('label_password').style.display='block';	
	}
}	
	

// Setzen von "closeUsrX" auf "true", um more_smiley Tab/Popup zu schließen
localStorage.setItem("closeUsrX", "true");

// Optional: Zurücksetzen, damit bei einem erneuten Aufruf der Wert wieder gesetzt werden kann
setTimeout(() => {
	localStorage.removeItem("closeUsrX");
}, 1000); // Entfernt den Wert nach 1 Sekunde

	
if (!navigator.platform.match(/iPhone/)) {
	setTimeout(function(){ document.getElementById('regname').focus(); }, 1500);
}
show_user = "<?php echo $show_user; ?>";
var supporter = "<?php echo $supporterValue; ?>";
	
// http://ichwill.net/chapter4.html

function addEvent(obj, evType, fn){
 if (obj.addEventListener){
   obj.addEventListener(evType, fn, false);
   return true;
 } else if (obj.attachEvent){
   var r = obj.attachEvent("on"+evType, fn);
   return r;
 } else {
   return false;
 }
}
addEvent(window, 'load', ZeitAnzeigen);

/* Für Support Chat: Zeigt die Support-Verfügbarkeit */


var testObj = null;
    testObj = new XMLHttpRequest();

	function eineFunktion() {
		if (document.getElementById("support_online")) {
			if (testObj.readyState == 4) {
				if (testObj.responseText == 1) {
					document.getElementById("support_online").innerHTML = '<span style="font-size:16px;vertical-align: -.2em">☞</span><?php echo _SUPPORT ?>';
					document.getElementById("support_online").style.color = "green";
				} else {
					document.getElementById("support_online").innerHTML = "<?php echo _NOSUPPORT ?>";
					document.getElementById("support_online").style.color = "red";
				}
			}
		}
	}

function update() {
    testObj.open("GET", "support_online.php");
    testObj.onreadystatechange = eineFunktion;
    testObj.send(null);
	
	window.setTimeout(update,5000);
}

if (supporter != "") {
	addEvent(window, 'load', update); //addEvent steht mobil nicht zur Verfügung?
}


/* Zeigt die User dynamisch */
var xhttp = null;
var xhttp = new XMLHttpRequest();

function eineFunktion2() {
	xhttp.onreadystatechange = function() {
		if (this.readyState == 4 && this.status == 200) {
			document.getElementById("user_online").innerHTML = this.responseText;			
		}
	};
}


function update2() {
	xhttp.open("GET", "user_online.php", true);
	xhttp.onreadystatechange = eineFunktion2;
	xhttp.send(null);
	
	window.setTimeout(update2,10000);
}

if (show_user == "yes") {	
	addEvent(window, 'load', update2); //addEvent steht mobil nicht zur Verfügung?
}


/* Zeigt die Online-today dynamisch */

if (document.getElementById('online_today')) {
	
	var x3http = null;
	var x3http = new XMLHttpRequest();

	function eineFunktion3() {
		x3http.onreadystatechange = function() {
			if (this.readyState == 4 && this.status == 200) {
				document.getElementById("online_today").innerHTML = this.responseText;
				if (document.getElementById("online_today2")) {
					document.getElementById("online_today2").innerHTML = this.responseText;
				}
			}
		};
	}


	function update3() {
		x3http.open("GET", "online_today.php", true);
		x3http.onreadystatechange = eineFunktion3;
		x3http.send(null);
	
		window.setTimeout(update3,25000);
	}
	addEvent(window, 'load', update3); 

}


/* Zeigt die Zeit bis Öffnung dynamisch */

if (document.getElementById('noch')) {

	var x2http = null;
	var x2http = new XMLHttpRequest();

	function eineFunktion4() {
		x2http.onreadystatechange = function() {
			if (this.readyState == 4 && this.status == 200) {
				document.getElementById("noch").innerHTML = this.responseText;
			}
		};
	}


	function update4() {
		x2http.open("GET", "noch_offline.php", true);
		x2http.onreadystatechange = eineFunktion4;
		x2http.send(null);

		window.setTimeout(update4,10000);
	}
	addEvent(window, 'load', update4);

}





var ablauf2 = new Date();
var Minuten2 = ablauf2.getTime() + (360 * 24 * 60 * 60 * 1000);
ablauf2.setTime(Minuten2);
function jump2(form) {
	order = form.menu2.selectedIndex;
	if (form.menu2.options[order].value != 0) {
               var style = form.menu2.options[order].value;
               document.cookie="Style="+style+"; expires=" + ablauf2.toGMTString();
               window.location.reload();
	}
}

function setlang(lg) {
	document.cookie="lang="+lg+"; expires=" + ablauf2.toGMTString();
}


if (screen.width <= 720) {
	document.cookie = "Style=7";
}


function show_stats() {
	document.getElementsByClassName('stats')[0].style.display="block";
	document.getElementById('stats_preview').style.display="none";
}


function lookup_reg() {
	curr_input = document.getElementById('regname').value;
	nickgross = <?php echo json_encode($nickgross) ?>;
	if (nickgross == 1) {
		if (curr_input.length == 1) {
			document.getElementById('regname').value = curr_input.toUpperCase();
		}
	}
	// console.log(curr_input);
	

	// Überprüfen, ob '/g' oder '/nog' im Eingabewert enthalten sind
	if (curr_input.length >= 5 && curr_input.includes('/g')) {
		// console.log("Die Eingabe enthält '/g'.");
		document.getElementById('password').style.display="unset";
		document.getElementById('label_password').style.display="unset";
		
	} else if (curr_input.length >= 7 && curr_input.includes('/nog')) {
		// console.log("Die Eingabe enthält '/nog'.");
		document.getElementById('password').style.display="unset";
		document.getElementById('label_password').style.display="unset";

	} else if (curr_input.length == 0) {
		document.getElementById('password').style.display="none";
		document.getElementById('label_password').style.display="none";

	} else {

	// AJAX-Anfrage an den Server senden
	var xhr = new XMLHttpRequest();
	xhr.open('GET', 'lookup.php?value=' + encodeURIComponent(curr_input), true);
	xhr.onload = function() {
		if (xhr.status === 200) {
			var response = xhr.responseText;
			// Überprüfen der Antwort
			if (response.includes('ist im Array enthalten')) {
				// Erfolgsfall: Ausführen von weiterem JavaScript-Code
				// console.log("Erfolgreich gefunden! Weitere Aktionen werden ausgeführt.");
				document.getElementById('password').style.display="unset";
				document.getElementById('label_password').style.display="unset";
				document.getElementById('first_legend').style.color="#555";
				document.getElementById('first_legend').innerHTML='<?php echo _LOGIN_FORM ?>';
				
			} else {
				// console.log("Wert nicht im Array gefunden.");
				document.getElementById('password').style.display="none";
				document.getElementById('label_password').style.display="none";
			}
		}
		};
		xhr.send();	
	}
	
}

if (/iPhone|iPad|iPod|Android/i.test(navigator.userAgent)) {
	localStorage.removeItem("chat_open");
	sessionStorage.removeItem("chat_open");
}

</script>


<?php if (file_exists("footer_inc.php")) include("footer_inc.php"); ?>

</body>
</html>