<?php
if ((ini_get('zlib.output_compression') != 1)) ob_start("ob_gzhandler");
header('Content-type: text/html; charset=utf-8');

$self = dirname($_SERVER['PHP_SELF']);
if ($self == "/") {$self="";}

$base = basename($_SERVER['HTTP_HOST']);
// HTTP / HTTPS bestimmen
if (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS']!='off' or $_SERVER['SERVER_PORT']==443) {
	$prot='https://';
} else {
	$prot='http://';
}
$aufruf = $prot.$base.$self;	
	


include("chat_config.php");


if (isset($stil) && $stil <> 0) {
        $s = $stil;
} elseif (isset($_COOKIE["Style"])) {
	$s = $_COOKIE["Style"];
} else {
        $s = $default_skin;
}


// Abfrage, ob Admin:
$admintrue = false;
$modstrue = false;
$nickname = "";

session_start();
if (isset($_SESSION['chatuser'])) {
	$nickname= $_SESSION['chatuser'];
}

if (in_array(utf8_decode($nickname), $admins)) {$admintrue = true;}
if (in_array($nickname, $admins)) {$admintrue = true;}

if (file_exists("admin/admins.txt") && file_exists("admin/admin_add_admins.php")) {
	$admins2 = file("admin/admins.txt",FILE_IGNORE_NEW_LINES); 
	if (in_array(utf8_decode($nickname), $admins2)) {$admintrue = true;}
	if (in_array($nickname, $admins2)) {$admintrue = true;}
}
if (file_exists("admin/mods.txt") && file_exists("admin/admin_mods.php")) {
	$mods = file("admin/mods.txt",FILE_IGNORE_NEW_LINES); 
	if (in_array(utf8_decode($nickname), $mods)) {$modstrue = true;}
}


?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="de" lang="de">

<head>
<meta name="language" content="de" >
<meta name="description" content="Hilfe zum Chat von webdesign weisshart" >
<meta name="keywords" content="@bots: please look for keywords in document body ;-)" >
<meta name="author" content="Dipl.-Ing.(FH) F. Weisshart" >
<meta name="generator" content="notepad ;-)" >
<meta name="robots" content="index, follow" >
<title>Hilfe zum Chat von webdesign weisshart </title>
<link rel="shortcut icon" href="favicon.ico" >
<link rel="stylesheet" type="text/css" media="screen" href="helpcss<?php echo $s; ?>.css" >
<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=1" > <!-- iPhone -->


<style>
	html {-webkit-text-size-adjust: 100%;}
	body {margin: 10px 10px 8em 10px;}
	ul {list-style-type: square;}
	ul ul {font-size:100%}
	li {margin: .3em 1.3em}
	ol li  {margin: 1.5em;}
	h2,h3 {margin-top: 3em;}
	h4 {margin-top:1em;}
	tr {color:#343;}
	td {
		border:1px solid #555;
		padding: 3px 5px;
		background:white;
	}
	#help, #sr {width:600px;margin:auto}
	#sr, .sr {
		position:absolute;
		left:-1000px;
		top:-1000px;
		width:0;
		height:0;
		overflow:hidden;
		display:inline;
	}

	@keyframes marquee {
		0%   { text-indent: 100% }
		100% { text-indent: -60% }
	}

	.marquee {
		display:block;
		width: 98%;
		margin: auto;
		overflow: hidden;
		white-space: nowrap;
		animation: marquee 10s linear infinite;
	}

	.marquee:hover {
		animation-play-state: paused;
	}

	@keyframes rotation {
		100% { 
			-webkit-transform: rotate(360deg); 
			transform:rotate(360deg); 
		}
	}

	.hinweis {
		font-weight:bold;
		color:#e00;
	}
	
	dfn, .dot {
		position:absolute;
		left:-1000px;
		top:-1000px;
		width:0;
		height:0;
		overflow:hidden;
		display:inline;
	}
	.blink {
		animation: blink 1.5s steps(2, start) infinite;
	}
	@keyframes blink {
		to { visibility: hidden;}
	}
	
	#footerlink {display:none;}
		
	@media only screen and (max-width : 480px) {
		#help {max-width:100%;}
		body {margin:0;padding:.5em;max-width:100%;}
		p,li {font-size:.9em;}
		table {width:99%;font-size:.8em;}
	}
	
	/* damit dunkle Firefox-Themes die Skins nicht zerschießen */
/*	@supports not (-moz-appearance:none) {
		@media (prefers-color-scheme: dark) {
			html {background:#000;}
			body, img{filter:invert(1);}
			#wdw_logo{filter:invert(0)}
		}
	}
*/
</style>


<!--
Das folgende Script verhindert, dass der Chat von deinem Server in ein (fremdes) Frameset eingebunden wird.
Wenn du dies willst, musst du dieses Script entkommentieren (das // loeschen).
//-->

<script>
// if (top != self) top.location = self.location;
</script>


<script>
/* <![CDATA[ */
function playsound(typ) { // die standardkonforme Loesung fuer alle Browser
      if (document.getElementById('ton')) {
      	document.getElementById("ton").innerHTML = '<audio src="'+typ+'" autoplay ></audio>';
      }
}
/* ]]> */
</script>

</head>
<body>

<div id="help">
<!-- ###### die folgenden Hilfetexte kannst du selbst anpassen ###### -->
<h1><a id="chathelp">Hilfe zum <span lang="en">Chat</span></a></h1>

<?php
$localFile = 'chtver.txt';
$version = file_get_contents($localFile);
echo '<p>Version: '.$version.'</p>';
?>
<?php if ($new_win != "yes") echo ' <p style = "margin: 2em 0"><a href="chat.php" onclick="history.back()">zur&uuml;ck zum <span lang="en">Chat</span></a></p>'; ?>
<p style = "margin: 2em 0">Das englische Wort <span lang="en">"Chat"</span> bedeutet so viel wie "sich unterhalten" oder "plaudern".
Das Ganze funktioniert so &auml;hnlich wie eine Konferenzschaltung am Telefon:
Du tippst einen Satz ein, den sofort alle anderen Teilnehmer der <span lang="en">Chat</span>-Runde sehen.
Du mu&szlig;t dich  nicht mit deinem Namen oder deiner Emailadresse registrieren.
Du entscheidest, ob du dich mit deinem echten Namen meldest, oder einen Fantasienamen als nick w&auml;hlst.
Du kannst also auch g&auml;nzlich anonym bleiben.
Umso mehr gilt: Bitte den Anstand wahren! <a href="http://de.wikipedia.org/wiki/Netikette"><dfn>externer&nbsp;Link:&nbsp;</dfn>Wikipedia &uuml;ber Netikette</a></p>

<h3>Den Chat aufrufen</h3>
<p>Grundsätzlich wird der Chat mit folgender Adresse aufgerufen:
<br><a href="login.php"><?php echo $aufruf ?>/login.php</a>
<br>Der Aufruf mit 
<br><a href="chat.php"><?php echo $aufruf ?>/chat.php</a> oder <a href="../chat"><?php echo $prot.$base ?>/chat</a>
kann zu einer Fehlermeldung führen, und ist nicht empfehlenswert.
</p>

<h4>Alternative Aufrufe</h4>
<ol>
	<li><a href="<?php echo $self ?>/chat-bf.php"><?php echo $aufruf ?>/chat-bf.php</a> öffnet den Chat mit dem Skin BF-Linear. Dieser Skin ist speziell für sehbehinderte Chatter optimiert: Gelbe Schrift auf blauem Hintergrund, Schrift stark vergrößerbar, Eingabefeld oben usw.
<br>Achtung! Dieser Skin bleibt gespeichert, auch wenn der Chat neu aufgerufen wird.		
Verlassen dieses Skins mit dem Dropdown-Menü "Seitenstil" unter Einstellungen.</li>
	
	<li>Beim Aufruf des Chat in einem Smartphone wird automatisch ein für kleine Monitore optimierter Skin eingestellt.</li>
</ol>



<h3>Hinweise:</h3>
<p>Der Betreiber des <span lang="en">"Chat"</span> hat keinen Einflu&szlig; auf die Meinungs&auml;u&szlig;erungen in den Chatr&auml;umen, und ist daher f&uuml;r die Inhalte nicht verantwortlich. Der Betreiber wird aber Meinungs&auml;u&szlig;erungen, die gegen Gesetze versto&szlig;en, unverz&uuml;glich entfernen, sobald er davon in Kenntnis gesetzt wird. </p>
<p>Verschiedene Funktionen wurden m&ouml;glicherweise vom Webmaster deaktiviert, und stehen dann nicht zur Verf&uuml;gung.</p>
<p>Die IP der Teilnehmer kann gespeichert werden.</p>


<?php
if ($admintrue !== false) {
echo '
<h3 style = "margin: 2em 0 0 0">Hinweise f&uuml;r den Webmaster:</h3>
<p>Installationshinweise: <a href="https://webdesign.weisshart.de/chat/readme.txt">readme.txt</a></p>
<p><a href="https://webdesign.weisshart.de/chat-faq.php"><abbr lang="en" title="frequently asked questions">FAQ</abbr></a></p>
<p><a href="https://forum.weisshart.de/">Support Forum</a></p>
';
}
?>

<h2>Tastaturbefehle</h2>
<p> Folgende Befehle stehen im Texteingabefeld zur Verf&uuml;gung:
<p class="hinweis">Achtung! alle Tastaturbefehle sind <span lang="en">case sensitiv</span>, d. h. Gro&szlig;-/Kleinschreibung beachten.
<br>Auch beim Nicknamen Gro&szlig;-/Kleinschreibung beachten.
</p>


<table>
	<tr>
		<td >@nick </td>
		<td>Nachricht an nick. Die Nachricht k&ouml;nnen alle sehen, aber bei nick wird sie hervorgehoben, und ist so leichter zu erkennen.
            <br>Alternativ und schneller: Klick auf einen Nick im Nachrichtenfenster. </td>
	</tr>

	<tr>
		<td>/pn @nick </td>
		<td>private (versteckte) Nachricht an nick (fl&uuml;stern)
			<br>Alternativ und schneller: Klick auf einen Nick in der User Liste. 
			<br>Hinweis: Admins können u.U. private Nachrichten lesen.</td>
	</tr>
	<tr>
		<td>@nick raumname_pr</td>
		<td>erzeugt eine gefl&uuml;sterte, anklickbare Einladung in einen privaten Raum. Der Raumname ist frei w&auml;hlbar, muss aber mit _pr enden.
			<br>Beispiel: Xyz123_pr @Tester
            <br>Alternativ und besser: Rechtsklick auf einen Nick in der User Liste. </td>
	</tr>
	<tr>
		<td>/color #000000</td>
		<td>Farbe f&uuml;r den eigenen Nick (Hexcode)
            <br>Einstellungen ▽ anklicken. Dort gibt es unter anderem ein Auswahlmen&uuml; f&uuml;r die Nickfarbe.</td>
	</tr>
	<tr>
		<td>/ignore nick<br>u. dann evtl. reload&nbsp;(F5)</td>
		<td>Verbirgt (nur bei dir) <b>alle</b> Nachrichten die nick schreibt, sowie alle Nachrichten (auch von Dritten) die diesen nick enthalten.<br>Max. 3 ignores sind m&ouml;glich; Admins und Mods können <b>nicht</b> ignoriert werden. Die ignorierten Nicks werden (rechts) unter "du bist im Raum …" angezeigt, sowie hinter dem Nick in der Userliste mit [igno] gekennzeichnet.</td>
	</tr>

	<tr>
		<td>/show<br>u. dann evtl. reload&nbsp;(F5)</td>
		<td>macht alle /ignore rückgängig</td>
	</tr>

	
	
	<tr>
		<td>/clear</td>
		<td>l&ouml;scht den Inhalt von privaten R&auml;umen (Admins und Mods: auch &ouml;ffentliche R&auml;ume)
            <br>... und wenn du die Meldung "... mal aufger&auml;umt" nicht willst:<br>/pn /clear</td>
	</tr>
	<tr>
		<td>/youtube xxxx</td>
		<td>Bettet ein Youtube Video ein. Anstelle von xxxx die Youtube ID einsetzen (nach watch?v=), z.B. /youtube Zglu4KADPrI.
			<br>Aber auch die direkte Eingabe eines YouTube Links ist m&ouml;glich. </td>
	</tr>
	<tr>
		<td>:br:</td>
		<td>Erzeugt einen Zeilenumbruch<br>Einfacher: Umschalt + Enter</td>
	</tr>
	<tr>
		<td>/version</td>
		<td>Zeigt die Versionsnummer</td>
	</tr>

</table>


<h3 style="margin-top:2em;">BB Codes</h3>
<table>
	<tr>
		<td>[b]fetter Text[/b]</td>
		<td style="font-weight:bold">fetter Text </td>
	</tr>

	<tr>
		<td>[i]Schrägschrift[/i]</td>
		<td style="font-style:italic">Schrägschrift </td>
	</tr>

	<tr>
		<td>[color=red]Text[/color]</td>
		<td style="color:red">Text </td>
	</tr>

	<tr>
		<td>[blink]blinkender Text[/blink]</td>
		<td><span class="blink">blinkender Text</span></td>
	</tr>

	<!-- <tr>
		<td>[scroll]Laufschrift[/scroll]</td>
		<td><span class ="marquee"><span>Laufschrift</span></span></td>
	</tr> -->

</table>

<h3 style="margin-top:2em;"> Befehle f&uuml;r Admins und Modis (diese Hilfe sehen nur Admins und Mods):</h3>

<?php

if ($admintrue !== false ||$modstrue !== false) {
echo '

<table>
	<tr>
		<td>/ban&nbsp;nick&nbsp;[min]</td>
		<td>(nur Admins und Mods): Sperrt den nick f&uuml;r [min] Minuten. (min ohne eckige Klammern eingeben)
		<br>Beispiel: /ban Maus 5 sperrt den User Maus für 5 Minuten
		<br>Wenn [min] nicht eingegeben wird, gilt eine (konfigurierbare) Standardzeit (z.B. 3&nbsp;Minuten)
		<br>Sperren heißt: Der Gesperrte kann weder lesen noch schreiben, wird aber in der Userliste mit der verbleibenden Sperrzeit angezeigt.
		</td>
	</tr>
	<tr>
		<td>/maulkorb nick [min]</td>
		<td>(nur Admins und Mods): wie /ban, aber der "Gemaulkorbte" kann weiterhin lesen.</td>
	</tr>
	
	<tr>
		<td>/nopv nick [min]</td>
		<td>(nur Admins und Mods): nick kann für [min] Minuten nicht mehr flüstern, und keine Privaträume erstellen.
		<br>Anzeige in der Userliste: <del>/pn</del></td>
	</tr>
	
	<tr>
		<td>/erase <em>Zeichenfolge</em></td>
		<td>(nur Admins und Mods): L&ouml;scht (alle) Nachricht(en), die <em>Zeichenfolge</em> enthalten.
		(auch im Datum oder Nick).
		<br>Alternativ und schneller: Rechtsklick auf den Nick der zu l&ouml;schenden Nachricht.
		<br><span class="hinweis">Hinweis: beide Partner einer gefl&uuml;sterten Nachricht sehen den Hinweis [message deleted] bis zur endgültigen Löschung. Es macht also keinen Sinn, eine geflüsterte Nachricht zu löschen.</span></td>
	</tr>

	<tr>
		<td>Beliebige Nachricht /pin</td>
		<td>Durch Anhängen von (Leerzeichen)/pin wird eine neu erstellte Nachricht "angepinnt". 
		<br>Das heißt, die Nachricht verschwindet nicht mehr aus dem angezeigten Bereich im Nachrichtenfenster, wenn neue Nachrichten dazu kommen, sondern bleibt am oberen Rand "kleben".
		<br>Hinweis:Angepinnte Nachrichten enthalten nur Text. Alle Bilder usw. werden ausgeblendet.
		</td>
	</tr>
	
	<tr>
		<td>/stick 16:10:05</td>
		<td>Nachträgliches Anpinnen einer Nachricht. <br>Im Beispiel wird die Nachricht mit der Uhrzeit 16:10:05 angepinnt.
		<br>Am einfachsten Rechtsklick auf die anzupinnende Nachricht. <br>Es erscheint /erase (Uhrzeit) im Schreibfenster. <br>Dann /erase ändern in /stick und Nachricht absenden.
		</td>
	</tr>
	
</table>
';
}
?>

<h3 style="margin-top:2em;"> Befehle f&uuml;r den Admin (diese Hilfe sehen nur Admins):</h3>

<?php
if ($admintrue !== false) {
echo '

<p class="hinweis">Hinweis: Alle folgenden Admin-Befehle werden geflüstert, und werden, wie geflüsterte Nachrichten, automatisch nach der eingestellten Dauer gelöscht. Manuelles Löschen ist daher nicht nötig. Nur der Admin selbst kann die Anzeige sehen.</p>

<table>

	<tr>
		<td>/ghost</td>
		<td>(nur Admin): zeigt den Admin nicht online.
                Abschicken einer Nachricht (auch ein Leerzeichen genügt) beendet den ghost mode.
				<br>Flüstern hingegen beendet den ghost mode nicht. </td>
	</tr>
	<tr>
		<td>Die "Hintertür"</td>
		<td>Admins können den Chat als Ghost betreten. <br>Dazu beim Login /ghost (oder /g) an den Nicknamen anhängen. </td>
	</tr>

	<tr>
		<td>/peep</td>
		<td>(nur Admin): zeigt dem Admin auch gefl&uuml;sterte Nachrichten. Voraussetzung: der Admin ist sichtbar, also NICHT /ghost 
                <br>/nopeep beendet den peep mode. </td>
	</tr>

	<tr>
		<td>/approve <em>Zeichenfolge</em></td>
		<td>(nur Admin): gibt (alle) moderierten Nachricht(en) frei, die <em>Zeichenfolge</em> enthalten.
                (auch im Datum oder Nick).
                <br>Alternativ und schneller: (await mod) anklicken. </td>
	</tr>
	
	';
	
	if (file_exists("add_inc.php")) {
		echo'
			<tr>
		<td><em>URL</em> /add1 oder /add2 usw. </td>
		<td>(nur Admin): Versucht, das Bild <em>URL</em> in das popup "more smileys" (Verzeichnis smileys1, smileys2 usw.) einzuf&uuml;gen.
		<br>Erlaubt sind .gif, .png, .mp3-Audios und .mp4-Videos</td>
		</tr>

		<tr>
		<td><em>:code:</em> /del_smiley</td>
		<td>(nur Admin): Löscht ein Smiley, z.B. :123: , das aus more smileys in die Eingabezeile eingefügt wurde.</td>
		</tr>
		<tr>
		<td>/del_all_smileys_in_box&nbsp;[Box]</td>
		<td>(nur Admin): Löscht alle Smileys in der angegebenen [Box], z.B. /del_all_smileys_in_box 3 leert die Smiley-Box Nr. 3</td>
		</tr>
		';
	}
	
	echo '
	
		<tr>
		<td>/offline</td>
		<td>(nur Admin): Schaltet den Chat offline. Dazu wird ein Raum namens Offline erzeugt.
		<br>Wahlweise kann der Admin in diesen Raum weitere Erkl&auml;rungen zum offline status schreiben.
		<br>Wieder online schalten: Den Raum Offline l&ouml;schen (mit /del Offline) </td>
	</tr>
	<tr>
		<td>/del Raumname</td>
		<td>(nur Admin): L&ouml;scht und entfernt einen Raum.
            <br>Achtung! dieser Befehl funktioniert <em>nicht</em> f&uuml;r den Raum, in dem du dich befindest.
			<br>Hinweis: Namen von Flüsterräumen enden mit _pr</td>
	</tr>


	<tr>
		<td>/showprofil</td>
		<td>(nur Admin): Listet alle angelegten Profile auf.</td>
	</tr>
	';


	if (isset($create_profile) && $create_profile == "yes") {
		echo '
		<tr>
		<td>/profil nick</td>
		<td>Zeigt das Profil von nick - falls nick ein Profil angelegt hat.</td>
		</tr>
		';
	}

	echo '
	<tr>
		<td>/topic Hier der Text</td>
		<td>(nur Admin): Erstellt ein Topic (Laufschrift) f&uuml;r den aktuellen Raum.<br>/topic ohne Text l&ouml;scht Topic
      <br>Hinweis: User müssen nach dem Topic setzen evtl. die Seite reloaden, um das Topic zu sehen.</td>
	</tr>
	
	
	<tr>
		<td>/ip<br>/noip</td>
		<td>(nur Admin): zeigt IP in der Userliste
                <br>/noip blendet IP aus. </td>
	</tr>
	

</table>



';
}
?>


<h2>Smileys per Tastatur eingeben</h2>
<p>Wer fit auf der Tastatur ist, zieht es eventuell vor, Smileys mit den folgenden K&uuml;rzeln einzugeben:
</p>


<table style="width:12em; max-width:40vw; float:left; margin-right:1em">

<tr><td>	:-) oder :)</td><td><img src="img/smile.gif"  alt="lacht" width="15" height="15" ></td></tr>
<tr><td>	;-) oder ;)</td><td><img src="img/smile_zwinker.gif"  alt="zwinkert" width="15" height="15" ></td></tr>
<tr><td>	:-( oder :(</td><td><img src="img/sad.gif"  alt="traurig" width="15" height="15" ></td></tr>
<tr><td>	XD oder xD</td><td><img src="img/xd.png"  alt="Smiley: grinst" width="16" height="16"></td></tr>
<tr><td>	:evil</td><td><img src="img/evil.gif"  alt="b&ouml;se" width="15" height="15" ></td></tr>
<tr><td>	:?</td><td><img src="img/confused.gif"  alt="verdutzt" width="15" height="15" ></td></tr>
</table>

<table style="width:12em; max-width:40vw; float:left; margin-right:1em">
<tr><td>	:-D oder :D</td><td><img src="img/broadsmile.gif" alt="lacht&nbsp;laut" width="15" height="15" ></td></tr>
<tr><td>	:p oder :P</td><td><img src="img/zunge.gif" alt="verschmitzt" width="15" height="15" ></td></tr>
<tr><td>	:8-) oder :8)</td><td><img lang="en" src="img/cool.gif" alt="cool" width="15" height="15" ></td></tr>
<tr><td>	:oops</td><td><img src="img/redface.gif" alt="verlegen" width="15" height="15" ></td></tr>
<tr><td>	:=)</td><td><img src="img/mrgreen.gif" alt="bleckt die Z&auml;hne" width="15" height="15" ></td></tr>
<tr><td>	:cry</td><td><img src="img/crying2.gif" alt="heult" width="15" height="15" ></td></tr>
<tr><td>	:lol</td><td><img src="img/lol.gif" alt="lacht&nbsp;schallend" width="15" height="15" ></td></tr>
</table>

<table style="width:15em; max-width:40vw;">
<tr><td>	:rofl</td><td><img src="img/kopf.gif" alt="steht&nbsp;Kopf" width="15" height="15" style="animation: rotation 2.7s infinite linear" ></td></tr>
<tr><td>	:tel</td><td><img src="img/tel.gif" alt="telefoniert" width="45" height="19" ></td></tr>
<tr><td>	:gruebel</td><td><img src="img/gruebel.gif" alt="gr&uuml;belt" width="19" height="17" ></td></tr>
<tr><td>	:wink oder :bye</td><td><img src="img/wink.gif" alt="winkt" width="25" height="15" ></td></tr>
<tr><td>	&lt;3</td><td><img src="img/coeuranime.gif" alt="Smiley: Herzen" width="25" height="16"></td></tr>

</table>


<br style="clear:left">

<h2><a id="pn">Private Nachrichten</a></h2>
<p>Einen der anwesenden <span lang="en">user</span> in der Liste anklicken, und nur du und der angeklickte user (der Empf&auml;nger) k&ouml;nnen die Nachricht sehen.</p>
<h3>Und wer das Ganze lieber per Tastatureingabe macht:</h3>
<p>Mit der Eingabe /pn @nick kannst du eine private Nachricht schicken.
Der Empf&auml;nger wird dabei mit seinem nick (Gro&szlig;-/Kleinschreibung beachten!) und vorgestelltem @ angesprochen.
<br>Eine private Nachricht k&ouml;nnte also folgenderma&szlig;en aussehen:
<br><em>@Hans diese Nachricht k&ouml;nnen nur wir beide lesen /pn</em></p>
<p>Es spielt keine Rolle, an welcher Stelle innerhalb der privaten Nachricht der Code /pn und der Empf&auml;ngername (mit vorangestellem @) stehen.</p>
<h3><strong>Hinweis:</strong></h3>
<p>Private Nachrichten sind <em>nicht "abh&ouml;rsicher".</em> Admins können mit einer speziellen Einstellung private Nachrichten lesen. Dies kann u.U. erforderlich sein, um z.B. Mobbing oder kriminelle Aktivitäten im Chat aufzudecken.
	<br>Aus dem gleichen Grund werden alle Nachrichten, auch private, für eine bestimmte Zeit archiviert.</p>

<?php

if (isset($create_profile) && $create_profile == "yes") {
echo '

<h2><a id="vk">Profile (Visitenkarten)</a></h2>
<h3>Erstellen eines eigenen Profils</h3>
<p>Nur registrierte User k&ouml;nnen ein Profil erstellen.</p>
<p>Wenn du registriert bist, klicke den Button "Dein Profil", um die Maske zur Erstellung oder zum &Auml;ndern deines Profils aufzurufen.
<br>Alternativ:<br>Gib im Chat den Befehl /xprofil ein.
Nach dem Absenden dieses Befehls erscheint im Nachrichtenfenster ein anklickbarer Link zur Eingabemaske.</p>

<h3>Einbinden eines Bildes (Avatar)</h3>
<p>Einfach die Upload-Funktion am Anfang des Profilformulars benutzen, um ein eigenes Bild von deinem Rechner hochzuladen.
<br>Zul&auml;ssig sind nur Bilder im .jpg oder .gif-Format.</p>

<h3>&Auml;ndern des eigenen Profils</h3>
<p>Du kannst dein Profil immer wieder &auml;ndern. Du erreichst dein Profil auf die gleiche Art wie oben (unter Profil erstellen) beschrieben.</p>

<h3>Anschauen des Profils</h3>
<p>User, die ein Profil angelegt haben, werden mit [P] (oder einem Icon) nach dem Namen gekennzeichnet.
<br>Zum Anschauen eines Profils einfach das [P] oder Icon anklicken.
<br>(Je nach Konfiguration k&ouml;nnen Alle, oder nur registrierte User Profile anschauen.)

<br>Alternativ:<br>
Im Chat /profil Name eingeben.
An Stelle von "Name" den Nicknamen des Users eingeben, dessen Profil du sehen willst.</p>

';
}
?>


<? if ($chat_light == "yes") echo "<!-- "; ?>
<div class="rooms">
<h2><a id="roomhelp">R&auml;ume:</a></h2>


<p>Wenn es hier im Standardraum bei vielen Teilnehmern zu hektisch wird, kannst du auch in einem der aufgelisteten &ouml;ffentlichen R&auml;ume chatten. </p>
<p>&Ouml;ffentliche R&auml;ume kannst du durch Anklicken des Raumnamens in der Liste betreten (falls angezeigt).</p>


<h3>Anlegen neuer R&auml;ume (nur Admin)</h3>
<?php
if ($admintrue !== false) {
echo '
<p><em>Achtung!</em> Der Raumname = Dateiname darf nur Buchstaben und Ziffern sowie den Unterstrich, aber keine Umlaute und Sonderzeichen, sowie keine Leerzeichen enthalten, und <em>muss</em> mit einem Gro&szlig;buchstaben beginnen.

<h4>M&ouml;glichkeit 1</h4>
<p>Mit einem Texteditor eine leere Datei mit dem Namen des neuen Raums anlegen.
<br>Diese Datei ins Verzeichnis /rooms auf den Server laden.
<br><em>Achtung!</em> Der Dateiname darf keine Endung wie .txt oder &auml;hnliches besitzen. 
Manche Texteditoren speichern Dateien automatisch mit der Endung .txt.
Notfalls per FTP auf dem Server die Endung .txt l&ouml;schen.
</p>

<h4>M&ouml;glichkeit 2</h4>
<p>Im Adressfeld des Browsers an die Adresse des Chat anh&auml;ngen:<br>
?room=Raumname (z. B. .../chat/chat.php?room=Dies_und_Das)<br> 
ENTER<br>
und eine erste Nachricht im neu erstellten Raum schreiben.
</p>
';
}
?>



<h3>Private R&auml;ume (Fl&uuml;sterr&auml;ume):</h3> 
<p>Wenn dein Thema nicht f&uuml;r die &Ouml;ffentlichkeit bestimmt ist, kannst du jederzeit selbst einen privaten Raum (Fl&uuml;sterraum) anlegen:
<br>Einfach den user, mit dem du in einen privaten Raum willst, in der Liste der anwesenden user <b>mit der rechten Maustaste klicken,</b> und "Los" oder Enter dr&uuml;cken.
<br>Android Smartphone / Tablet: Lange drücken.
</p>
<br>
<p>Falls das mit deinem Browser nicht funktioniert (z.B. iPhone):
<br>Schreibe einen frei erfundenen Namen f&uuml;r den Fl&uuml;sterraum, mit angeh&auml;ngtem _pr. und den User, den User, den du einladen willst.<br>Also so: Xyz_pr @Peter  (Der Raumname darf keine Umlaute oder Sonderzeichen enthalten, und muss mit einem Großbuchstaben beginnen!)</p>

<p><br>Alle &ouml;ffentlichen R&auml;ume werden nach
<?php
if ($clean > 48) {
	$clean = $clean/24;
	echo $clean." Tagen ";
} else {
	echo $clean." Stunden ";
}
?>
Inaktivit&auml;t gel&ouml;scht (konfigurierbar).
<br>Alle privaten R&auml;ume werden nach
<?php
if ($clean_priv > 48) {
	$clean_priv = round($clean_priv/24);
	echo $clean_priv." Tagen ";
} else {
	echo $clean_priv." Stunden ";
}
?>
Inaktivit&auml;t gel&ouml;scht (konfigurierbar).
<br>Aber du kannst ja einen privaten Raum jederzeit selbst wieder anlegen, wie oben beschrieben.</p>
<h3><strong>Hinweis:</strong></h3>
<p>Private R&auml;ume sind <em>nicht "abh&ouml;rsicher"!</em> Jeder, der den Namen des privaten Raums kennt oder err&auml;t, kann den Raum betreten.</p>

</div>
<?php if ($chat_light == "yes") echo " //-->"; ?>


<?php if ($chat_light != "yes") echo "<!-- "; ?>
<div class="rooms">
<h2><a name="roomhelp" id="roomhelp">R&auml;ume:</a></h2>


<p><br><em>Private R&auml;ume (Fl&uuml;sterr&auml;ume):</em> Wenn dein Thema nicht f&uuml;r die &Ouml;ffentlichkeit bestimmt ist, kannst du deinen Chatpartner in einen privaten Raum (Fl&uuml;sterraum) einladen.</p>
<p>Dazu benutzt du am besten eine <a href="#pn">private Nachricht</a>  in folgender Form:
<br>/pn @nick bitte komm in den Raum Raumname_pr
<br>Der Raumname sollte nicht leicht zu erraten sein, darf keine Sonderzeichen (&auml; &ouml; usw.) und keine Leerzeichen enthalten, und mu&szlig; mit _pr (Unterstrich + pr)enden.
</p>

<p><br>Private R&auml;ume, werden nach
<?
if ($clean_priv > 48) {
	$clean_priv = $clean_priv/24;
	echo $clean_priv." Tagen";
} else {
	echo $clean_priv." Stunden";
}
?>
Inaktivit&auml;t gel&ouml;scht. Aber du kannst ja den Raum jederzeit selbst wieder anlegen, wie oben beschrieben.</p>
</div>
<?php if ($chat_light != "yes") echo " //-->"; ?>

<?php if ($imginclude != "yes") echo "<!-- "; ?>
<h2>Bilder und Musik einf&uuml;gen:</h2>
<p>Einfach die URL (Adresse) des Bildes eingeben. Beispiel: www.example.com/bild.jpg
<br>Hinweis: Das direkte Einbinden von Bildern (sogenanntes hot linking) setzt voraus, dass der Eigent&uuml;mer des Bildes damit einverstanden ist.</p>
<p> <br><em>Dateien von deiner Festplatte:</em> Datei Upload sucht nach Dateien auf deinem Rechner. Der Upload beginnt automatisch nach Auswahl einer Datei. Sobald der Upload beendet ist, erscheint eine entsprechende Meldung, und du kannst die soeben hochgeladenen Datei mit einem Klick ins Nachrichtenfeld einf&uuml;gen, und mit ENTER oder LOS abschicken.
<br>M&ouml;glich sind Bilder im Format jpg, png, gif, die modernen Formate webp und avif, sowie Videos im mp4 Format und Sounddateien im mp3 Format. Die maximale Dateigr&ouml;&szlig;e ist eventuell begrenzt.
Der Upload von mp3 Dateien ist eventuell eingeschr&auml;nkt.
In jedem Fall sind Urheber- und Auff&uuml;hrungsrechte (GEMA u. a.) zu beachten.</p>
<?php if ($imginclude != "yes") echo " //--> "; ?>

<h2>Einzelne oder mehrere Nachrichten l&ouml;schen: (nur Admins und Mods)</h2>
<?php
if ($admintrue !== false ||$modstrue !== false) {
echo '

<p>Der Admin kann einzelne oder mehrere Nachrichten l&ouml;schen.
<br>Entweder durch Eingabe von /erase <em>Zeichenfolge</em> alle Nachrichten, die <em>Zeichenfolge</em> im Datum, Nick oder im Nachrichtentext enthalten.
<br>Oder durch Anklicken eines Nick im Nachrichtenfenster. Dadurch wird /erase Zeit ins Eingabefeld &uuml;bernommem, und die betreffende Nachricht beim Absenden gel&ouml;scht.
<br>Achtung! der L&ouml;schbefehl ist sehr m&auml;chtig. Die Eingabe von /erase 05 l&ouml;scht zum Beispiel alle Nachrichten, die im Monat Mai erstellt wurden - auch, wenn das Datum nicht angezeigt wird. </p>

<h2>Eine Wunschfarbe f&uuml;r den eigenen Nick:</h2>
<p>Unter Einstellungen &gt; Nickfarbe kannst du eine Wunschfarbe f&uuml;r deinen eigenen nick und deine Nachrichten einstellen.
<br>Alternativ:  Eingabe von /color #0000FF (hexadezimaler Farbcode - <a href="http://www.htmlhelp.com/cgi-bin/color.cgi">Beispiele hier</a>)
</p>
';
}
?>



<h2>Die Schriftgr&ouml;&szlig;e einstellen:</h2>
<p>Unter Einstellungen ▽ gibt es den Punkt "Schriftgröße". Der mögliche (weil sinnvolle) Bereich reicht von 80% bis 175%. </p>
<p>Alternativ kannst du die Schriftgr&ouml;&szlig;e direkt im Browser nach deinen W&uuml;nschen einstellen.</p>
<ul>
<li>W&auml;hle im Men&uuml;: Ansicht (oder Darstellung o.ä.) - Schriftgrad bzw. Schriftgröße</li>
<li>In den meisten modernen Browsern gibt es hierf&uuml;r auch eine einfache Tastenkombination:
<ul>
<li>Strg und Plustaste f&uuml;r gr&ouml;&szlig;er</li>
<li>Strg und Minustaste f&uuml;r kleiner</li>
<li> Strg und 0 (Null) f&uuml;r Standardgr&ouml;&szlig;e</li>
</ul>
</li>
</ul>

<h2><a id="datenschutz">Hinweis zum Datenschutz</a></h2>
<p>Die Mitteilungen werden auf dem Server des Chatbetreibers zwischengespeichert, und k&ouml;nnen dort vom Chatbetreiber eingesehen werden.<br>In privaten R&auml;umen gibt es eine L&ouml;schm&ouml;glichkeit: einfach /clear eingeben. Gel&ouml;scht wird dabei der Inhalt des Raums, nicht der Raum selbst. Gel&ouml;schte Daten werden je nach Konfiguration eventuell archiviert.</p>

<h2><span lang="en">Cookies:</span></h2>
<p>Das Script versucht, verschiedene <span lang="en">cookies</span> zu setzen. Wenn dein <span lang="en">Browser cookies</span> akzeptiert, wird dein nick (sowie eine eventuell gew&auml;hlte Farbe und weitere Einstellungen) auf deinem Rechner als <span lang="en">cookie</span> gespeichert, und beim n&auml;chsten Besuch im <span lang="en">Chat</span> wieder verwendet.</p>
<p>Du musst <span lang="en">cookies</span> zulassen, um den <span lang="en">Chat</span> zu nutzen.
<br>Die <span lang="en">cookies</span>, und damit deine Einstellungen, werden nach sp&auml;testens 360 Tagen automatisch ohne dein Zutun wieder gel&ouml;scht.</p>
<p><a href="http://de.wikipedia.org/wiki/HTTP_Cookie"><dfn>externer&nbsp;Link:&nbsp;</dfn><span lang="en">Cookie</span>: was ist das? - ist das gef&auml;hrlich?</a></p>

<h2>Danksagung</h2>
<p>Backgrounds f&uuml;r einzelne Styles von <a href="http://photocase.de/de/">photocase</a> und <a href="http://www.mandolux.com/">mandolux</a>.</p>
<p>Zufällige Background-Fotos für den Style Fotos: <a href="https://source.unsplash.com/">unsplash.com</a></p>
<p>Besonderen Dank an:
<br>Rainer f&uuml;r viele originelle Ideen,
<br>Martin "the bugfinder",
<br>Slava f&uuml;r die utf-8 Unterst&uuml;tzung,
<br><a href="http://elmicoxcodes.blogspot.com/2007/03/asynchronous-upload-like-ajax-1.html">micox</a> f&uuml;r den asynchronen upload,
<br><a href="http://getid3.sourceforge.net/">getID3</a> f&uuml;r die Pr&uuml;fung der hochgeladenen Dateien,

</p>


<?php if ($new_win != "yes") echo ' <p style = "margin: 2em 0"><a href="chat.php" onclick="history.back()">zur&uuml;ck zum <span lang="en">Chat</span></a></p>'; ?>

</div>
<br>
<!-- ###### die folgenden Hilfetexte sind nur fuer blinde Benutzer, und werden im Browser nicht angezeigt ###### -->
<div id="sr" tabindex="-1">

<h1>Hinweise f&uuml;r blinde Benutzer</h1>


<p style = "margin: 2em 0"><a href="chat.php" onclick="history.back()">zur&uuml;ck zum Chat</a></p>

<p>Die Versierten unter euch werden auch ohne diese Kurzanleitung klar kommen, denn der Chat ist weitgehend barrierefrei und selbsterkl&auml;rend.</p>
<p>Der Chat ist mit allen gängigen Screen Readern nutzbar.
Empfehlung: Der Screen Reader NVDA zusammen mit dem Firefox sind die optimale Ausrüstung für den Chat.
Der <a href="https://www.nvaccess.org/">NVDA</a> ist kostenlos, schlank, schnell, stabil.</p>

<p>Sobald eine Meldung einlangt, wird diese Meldung von NVDA und von Jaws sowie VoiceOver und Talkback automatisch angesagt, da diese Screen Reader ARIA Live unterstützen. Der Fokus verbleibt im Eingabefeld, sodass sofort geantwortet werden kann. Bei anderen Screen Readern musst du eventuell nach oben navigieren, um die zuletzt geposteten Nachrichten zu lesen.</p>
	
	
<h2>Allgemeine Hinweise</h2>

<p>Solltest du einmal die Orientierung verlieren oder am Seitenbeginn stehen, gilt folgende Faustregel:<br>
Zum ersten Eingabefeld f&uuml;r die Nachricht navigieren. Unmittelbar dar&uuml;ber befinden sich die Nachrichten, darunter der <span xml:lang="en" lang="en">Button</span> zum Absenden.</p>

<h3>Unterst&uuml;tzung durch <span xml:lang="en"  lang="en">Sounds</span>:</h3>
<!-- <p>Unterschiedliche Tonsignale k&uuml;ndigen &Auml;nderungen auf der Seite an.</p>  -->

<p>Bei eingehenden Nachrichten ert&ouml;nt das folgende Tonsignal: <a href="javascript:playsound('<?php echo $sound4 ?>')">Signal f&uuml;r Eingang</a></p>
<!-- <li>Wenn ein neuer Besucher den Raum betritt, oder wenn du einen Raum betrittst, in dem sich bereits jemand befindet, ist der folgende Klang zu h&ouml;ren: <a href="javascript:playsound('<?php echo $sound2 ?>')">Signal f&uuml;r neuen Besucher</a></li>
<li>Wenn ein Besucher den Raum verl&auml;sst, ist der folgende Klang zu h&ouml;ren: <a href="javascript:playsound('<?php echo $sound5 ?>')">Signal f&uuml;r Besucher verl&auml;sst den Raum</a></li> -->




<h2>Danksagung:</h2>
<p>Danke an <a href="https://aus-meiner-feder.at/">Eva Papst</a> f&uuml;r das geduldige Austesten des Chats, f&uuml;r viele Anregungen zur Verbesserung der Barrierefreiheit, und f&uuml;r die Erstellung dieser Hinweise f&uuml;r blinde Benutzer.</p>

<?php if ($new_win != "yes") echo ' <p style = "margin: 2em 0"><a href="chat.php" onclick="history.back()">zur&uuml;ck zum <span lang="en">Chat</span></a></p>'; ?>


</div>
<div id="ton"></div>

<?php if (file_exists("footer_inc.php")) include("footer_inc.php"); ?>

</body>
</html>