<?php
################################################################################################
# Der Chat von webdesign.weisshart.de                                                          #
# Diese Datei nicht aendern!                                                                   #
# Alle Einstellungen koennen in der chat_config.php und in den CSS Dateien vorgenommen werden. #
# Weitere Hinweise in der readme.txt                                                           #
################################################################################################

// error_reporting(E_ALL);

if (phpversion() < '7.4.0') {
	echo "<p>Dieses Script erfordert PHP Version 7.4.0 oder h&ouml;her!<br >";
	echo "auf Deinem Server l&auml;uft aber PHP Version ".phpversion().".</p>";
	exit();
}

if (file_exists("user/user_stat_dyn.php")) {
	include ('user/user_stat_dyn.php');
} 


$ip_sperre =  'user/sperre.txt';

if (file_exists($ip_sperre)) {
	$filemtime=filemtime ($ip_sperre);
	$now   = time();
	if (filesize($ip_sperre) > 6 && $now - filemtime($ip_sperre) < 60 * 60 * 24) {
	
		$IP_denylist = file($ip_sperre);	
		for($i = 0; $i < count($IP_denylist); $i++) {
			if ($_SERVER['REMOTE_ADDR'] == trim($IP_denylist[$i])) {
				header("location: https://google.com/"); //Auf eine beliebige Seite umleiten
				exit();
			}
		}
	}
} 


// Chat zeitabhaengig offline:
$ab_offen_seconds = 0; // Standardwert

if (file_exists('admin/set_offline.txt')) {
	$times_online = trim(file_get_contents('admin/set_offline.txt'));

	// Format prüfen: HH:MM - HH:MM
	if (preg_match('/^(?:[01]\d|2[0-3]):[0-5]\d - (?:[01]\d|2[0-3]):[0-5]\d$/', $times_online)) {
		list($ab_offen, $bis_offen) = array_map('trim', explode('-', $times_online));
		list($h, $m) = explode(':', $ab_offen);
		$ab_offen_seconds = $h * 3600 + $m * 60;
	}
}


// if (file_exists("notr_inc.php")) include("notr_inc.php");
if (file_exists("nodl_inc.php")) include("nodl_inc.php");
require_once dirname(__FILE__) . '/MobileDetect3.php';
$detect = new \Detection\MobileDetect;

$host  = $_SERVER['HTTP_HOST'];
$uri  = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
$extra1 = 'login.php';
if (!isset($_COOKIE["arrival"]) ) {
	header("Location: //$host$uri/$extra1");				
	exit();
} 

header('Content-type: text/html; charset=utf-8');

if (!headers_sent() && isset($_SERVER['HTTP_ACCEPT_ENCODING']) && strpos($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip') !== false && !in_array('Content-Encoding: gzip', headers_list())) {
	ob_start("ob_gzhandler");
}

if(!isset($_SESSION)){session_start();}


// if (!isset($popup)) {$popup = "disable";}
if(!isset($max_length)) $max_length = 500;
if(!isset($pic_small)) $pic_small = 37;
if(!isset($vid_small)) $vid_small = 70;

// setcookie("correct_logout","0",time()+86400*30);

setcookie('correct_logout', 0, [
    'expires' => time() + 86400*30,
    'secure' => true,
    'httponly' => true,
    'samesite' => 'Strict',
]);

// ab PHP 7.2 führt fehlende Konstante zu fatal error. Fallback:
function constOrDefault($name, $fallback = null) {
    return defined($name) ? constant($name) : ($fallback ?? $name);
}

if (isset($_SESSION['chatuser'])) {$nick= $_SESSION['chatuser'];}
include("chat_config.php");


if (extension_loaded('gd')) {
	$gd = true;
} else {
	$gd = false;
}



// von upa.php hierher:
function memory_limit_bytes() {
	$val = ini_get('memory_limit');
	if ($val == -1) {
		return -1; // unbegrenzt
	}
	$unit = strtolower(substr($val, -1));
	$num = (int)$val;
	switch ($unit) {
		case 'g':
			$num *= 1024;
		case 'm':
			$num *= 1024;
		case 'k':
			$num *= 1024;
	}
	return $num;
}

$maxsize_a = $maxsize; // kB
$upload_max_size = floatval((ini_get('upload_max_filesize'))) * 1024; // kB

$mem_limit = memory_limit_bytes() / 1024; // kB

if ($mem_limit > 0) {
	$mem_avail = $mem_limit / 5; // statt komischer Faktor (1024/5)
	$maxsize_b = min($maxsize_a, $upload_max_size, $mem_avail);
} else {
	// -1 = unbegrenzt
	$maxsize_b = min($maxsize_a, $upload_max_size);
}

// echo $maxsize_b; // kB
// exit;



// Zoom für skin bf-linear;
$font_size ="125";
if (isset($_COOKIE["size"]) && $_COOKIE["size"] == "200") {
	$font_size = "170";
} elseif (isset($_COOKIE["size"]) && $_COOKIE["size"] == "300") {
	$font_size = "300";
} elseif (isset($_COOKIE["size"]) && $_COOKIE["size"] == "100") {
	$font_size = "125";
}

// ein paar Variablen initialisieren:
$nickname = '';
$admintrue = '';
$modtrue = '';
$supportchat = '';


// // Setup: div Ordner erstellen usw.
// if(file_exists("setup.php")) {include ("setup.php");}
//
// // Setup nur einmal aufrufen:
// if (file_exists("setup.php") && file_exists("admin/.htaccess")) {
// 	@rename("setup.php","setup.bak");
// }



// Variable fuer shortlink() setzen abhaengig vom per cleanup.php erstellten file:
$is_fp = false;
if (file_exists("fp.txt") && file_get_contents("fp.txt") == "yes") $is_fp = true;

// Sprache abfragen:
if (isset($_COOKIE["lang"])) {
	$lang = $_COOKIE["lang"];
} else {
	$lang = $languages[0];
}
$lang = (isset($languages) && is_array($languages) && in_array($lang, $languages)) ? $lang : "de";

function isMobile() {   
	if (isset($_SERVER['HTTP_USER_AGENT'])) {
	    		if(preg_match('/(alcatel|amoi|android|avantgo|blackberry|benq|cell|cricket|docomo|elaine|htc|iemobile|iphone|ipad|ipaq|ipod|j2me|java|midp|mini|mmp|mobi|motorola|nec-|nokia|palm|panasonic|philips|phone|sagem|sharp|sie-|smartphone|sony|symbian|t-mobile|telus|up\.browser|up\.link|vodafone|wap|webos|wireless|xda|xoom|zte)/i', $_SERVER['HTTP_USER_AGENT'])) {
	    	return true;
		} else {
	    	return false;
		}
	} else {
		echo "<p style='color:red'><br ><br >Dein Browser schickt keinen User Agent String. Du kannst den Chat mit dieser Einstellung leider nicht oder nur sehr eingeschränkt verwenden.<br >";
		return false;
	}
}


$lang_file = 'lang'.strtoupper($lang).'_inc.php';

$in_regdb = false;

if (file_exists($lang_file)) {
	include ($lang_file);
}

$admins1 = $admins;

if (file_exists("admin/admins.txt") && file_exists("admin/admin_add_admins.php")) {
	$admins2 = file("admin/admins.txt",FILE_IGNORE_NEW_LINES); 
	$admins = array_merge($admins, $admins2); // und was, wenn kein $admins?
}

if (file_exists("admin/mods.txt") && file_exists("admin/admin_mods.php")) {
	$mods = file("admin/mods.txt",FILE_IGNORE_NEW_LINES); 
}

if (file_exists("admin/verified.txt") && file_exists("admin/admin_verified.php")) {
	$ver_user = file("admin/verified.txt",FILE_IGNORE_NEW_LINES); 
}


// if (file_exists("ip_tracker_responsetime.php")) {
// 	include ("ip_tracker_responsetime.php");
// }

############# Anzeigeoptionen abfragen ##########
if (isset($_COOKIE["Style"])) { // damit der Aufruf mit chat_bf.php zu Skin 12 führt. Zurück: Cookies löschen in login
	$s = $_COOKIE["Style"];
} elseif (isset($stil) && $stil <> 0) {
        $s = $stil;
} elseif (isset($_COOKIE["Style"])) {
	$s = $_COOKIE["Style"];
} else {
	$s = $default_skin;
}

$con = time()+3600*24*360;
$coff = time()-3600*24*360;

################# reverse ###################
if (!isset($_COOKIE["rev"]))  {
	$rev = "0";
	$display_reverse = false;
} elseif (isset($_COOKIE["rev"]) && $_COOKIE["rev"] == "1")  {
	$rev = "1";
	$display_reverse = true;
}
if (isset($_POST['rev']) && $_POST['rev'] == "1") {
	$rev = "1";
	$display_reverse = true;
	setcookie('rev','1',$con);
} elseif (isset($_POST['rev']) && $_POST['rev'] == "0") {
	$rev = "0";
	$display_reverse = false;
	setcookie('rev','1',$coff);
}

################# mehrzeilig ###################
// if (!isset($_COOKIE["mz"]))  {
// 	$m = "1";
// } elseif (isset($_COOKIE["mz"]) && $_COOKIE["mz"] == "0")  {
// 	$m = "0";
// }
// if (isset($_POST['m']) && $_POST['m'] == "0") {
// 	$m = "0";
// 	setcookie('mz','0',$con );
// } elseif (isset($_POST['m']) && $_POST['m'] == "1") {
// 	$m = "1";
// 	setcookie('mz','0',$coff);
// }




################# Datum im Chatfenster ###################
if (!isset($_COOKIE["dc"]))  {
	$dc = "1";
} elseif (isset($_COOKIE["dc"]) && $_COOKIE["dc"] == "0")  {
	$dc = "0";
}
if (isset($_POST['dc']) && $_POST['dc'] == "0") {
	$dc = "0";
	setcookie('dc','0',$con );
} elseif (isset($_POST['dc']) && $_POST['dc'] == "1") {
	$dc = "1";
	setcookie('dc','0',$coff);
}

################# Uhr im Chatfenster ###################
if (!isset($_COOKIE["uhr"]))  {
	$uhr = "1";
} elseif (isset($_COOKIE["uhr"]) && $_COOKIE["uhr"] == "0")  {
	$uhr = "0";
}
if (isset($_POST['uhr']) && $_POST['uhr'] == "0") {
	$uhr = "0";
	setcookie('uhr','0',$con );
} elseif (isset($_POST['uhr']) && $_POST['uhr'] == "1") {
	$uhr = "1";
	setcookie('uhr','0',$coff);
}



################# Bilder ###################
if (!isset($_COOKIE["pic"]))  {
	$pic = "1";
} elseif (isset($_COOKIE["pic"]) && $_COOKIE["pic"] == "0")  {
	$pic = "0";
}
if (isset($_POST['pic']) && $_POST['pic'] == "0") {
	$pic = "0";
	setcookie('pic','0',$con );
} elseif (isset($_POST['pic']) && $_POST['pic'] == "1") {
	$pic = "1";
	setcookie('pic','0',$coff);
}

################# freeze Gifs ###################
if (!isset($_COOKIE["freeze"]))  {
	$freeze = "1";
} elseif (isset($_COOKIE["freeze"]) && $_COOKIE["freeze"] == "0")  {
	$freeze = "0";
}
if (isset($_POST['freeze']) && $_POST['freeze'] == "0") {
	$freeze = "0";
	setcookie('freeze','0',$con );
} elseif (isset($_POST['freeze']) && $_POST['freeze'] == "1") {
	$freeze = "1";
	setcookie('freeze','0',$coff);
}


################# Bilderkleiner ###################

if (isset($_COOKIE["smallpic"]))  {setcookie("smallpic", "", time()-3600);}

################# User-online-Anzeige ###################
// if (!isset($_COOKIE["uoa"]))  {
// 	$uoa = "1";
// } elseif (isset($_COOKIE["uoa"]) && $_COOKIE["uoa"] == "0")  {
// 	$uoa = "0";
// }
// if (isset($_POST['uoa']) && $_POST['uoa'] == "0") {
// 	$uoa = "0";
// 	setcookie('uoa','0',$con );
// } elseif (isset($_POST['uoa']) && $_POST['uoa'] == "1") {
// 	$uoa = "1";
// 	setcookie('uoa','0',$coff);
// }


################# Avatare ###################
if (!isset($_COOKIE["avt"]))  {
	$avt = "1";
} elseif (isset($_COOKIE["avt"]) && $_COOKIE["avt"] == "0")  {
	$avt = "0";
}
if (isset($_POST['avt']) && $_POST['avt'] == "0") {
	$avt = "0";
	setcookie('avt','0',$con );
} elseif (isset($_POST['avt']) && $_POST['avt'] == "1") {
	$avt = "1";
	setcookie('avt','0',$coff);
}

################# Sounds ###################
if (!isset($_COOKIE["sound"]))  {
	$sound = "1";
} elseif (isset($_COOKIE["sound"]) && $_COOKIE["sound"] == "0")  {
	$sound = "0";
}
if (isset($_POST['sound']) && $_POST['sound'] == "0") {
	$sound = "0";
	setcookie('sound','0',$con );
} elseif (isset($_POST['sound']) && $_POST['sound'] == "1") {
	$sound = "1";
	setcookie('sound','0',$coff);
}

################# bg mobil ###################
if (!isset($_COOKIE["bg_mob"]))  {
	$bg_mob = "0";
} elseif (isset($_COOKIE["bg_mob"]) && $_COOKIE["bg_mob"] == "1")  {
	$bg_mob = "1";
}
if (isset($_POST['bg_mob']) && $_POST['bg_mob'] == "0") {
	$bg_mob = "0";
	setcookie('bg_mob','0',$coff );
} elseif (isset($_POST['bg_mob']) && $_POST['bg_mob'] == "1") {
	$bg_mob = "1";
	setcookie('bg_mob','1',$con);
}

################# bg mobil invers ###################
if (!isset($_COOKIE["dark"]))  {
	$dark = "0";
} elseif (isset($_COOKIE["dark"]) && $_COOKIE["dark"] == "1")  {
	$dark = "1";
}
if (isset($_POST['dark']) && $_POST['dark'] == "0") {
	$dark = "0";
	setcookie('dark','0',$coff );
} elseif (isset($_POST['dark']) && $_POST['dark'] == "1") {
	$dark = "1";
	setcookie('dark','1',$con);
}

################# enable invers ###################
if (!isset($_COOKIE["enable_dark"]))  {
	$enable_dark = "0";
} elseif (isset($_COOKIE["enable_dark"]) && $_COOKIE["enable_dark"] == "1")  {
	$enable_dark = "1";
}
if (isset($_POST['enable_dark']) && $_POST['enable_dark'] == "0") {
	$enable_dark = "0";
	setcookie('enable_dark','0',$coff );
} elseif (isset($_POST['enable_dark']) && $_POST['enable_dark'] == "1") {
	$enable_dark = "1";
	setcookie('enable_dark','1',$con);
}

################# Popup ###################
if (!isset($_COOKIE["pop_up"]))  {
	$pops = "aus";
} elseif (isset($_COOKIE["pop_up"]) && $_COOKIE["pop_up"] == "aus")  {
	$pops = "zeigen";
}
if (isset($_POST['pop_up']) && $_POST['pop_up'] == "zeigen") {
	$pops = "zeigen";
	setcookie('pop_up','aus',$con );
} elseif (isset($_POST['pop_up']) && $_POST['pop_up'] == "aus") {
	$pops = "aus";
	setcookie('pop_up','aus',$coff);
}

################# Fettschrift ###################
if (!isset($_COOKIE["nickfarben"]))  {
	$nickfarben = "1";
} elseif (isset($_COOKIE["nickfarben"]) && $_COOKIE["nickfarben"] == "0")  {
	$nickfarben = "0";
}
if (isset($_POST['nickfarben']) && $_POST['nickfarben'] == "0") {
	$nickfarben = "0";
	setcookie('nickfarben','0',$con );
} elseif (isset($_POST['nickfarben']) && $_POST['nickfarben'] == "1") {
	$nickfarben = "1";
	setcookie('nickfarben','0',$coff);
}

################# Schriftfarben ###################
if (!isset($_COOKIE["nickfarben2"]))  {
	$nickfarben2 = "1";
} elseif (isset($_COOKIE["nickfarben2"]) && $_COOKIE["nickfarben2"] == "0")  {
	$nickfarben2 = "0";
}
if (isset($_POST['nickfarben2']) && $_POST['nickfarben2'] == "0") {
	$nickfarben2 = "0";
	setcookie('nickfarben2','0',$con );
} elseif (isset($_POST['nickfarben2']) && $_POST['nickfarben2'] == "1") {
	$nickfarben2 = "1";
	setcookie('nickfarben2','0',$coff);
}

// ################# Online Zeit ###################
// if (!isset($_COOKIE["time_online"]))  {
// 	$time_online = "0";
// } elseif (isset($_COOKIE["time_online"]) && $_COOKIE["time_online"] == "1")  {
// 	$time_online = "1";
// }
// if (isset($_POST['time_online']) && $_POST['time_online'] == "1") {
// 	$time_online = "1";
// 	setcookie('time_online','1',$con );
// } elseif (isset($_POST['time_online']) && $_POST['time_online'] == "0") {
// 	$time_online = "0";
// 	setcookie('time_online','1',$coff);
// }
//
// ################# Aktuelle Uhrzeit ###################
// if (!isset($_COOKIE["time_real"]))  {
// 	$time_real = "0";
// } elseif (isset($_COOKIE["time_real"]) && $_COOKIE["time_real"] == "1")  {
// 	$time_real = "1";
// }
// if (isset($_POST['time_real']) && $_POST['time_real'] == "1") {
// 	$time_real = "1";
// 	setcookie('time_real','1',$con );
// } elseif (isset($_POST['time_real']) && $_POST['time_real'] == "0") {
// 	$time_real = "0";
// 	setcookie('time_real','1',$coff);
// }

################# Chat Up Player ###################
if (!isset($_COOKIE["chat_up_player"]))  {
	$chat_up_player = "1";
} elseif (isset($_COOKIE["chat_up_player"]) && $_COOKIE["chat_up_player"] == "0")  {
	$chat_up_player = "0";
} else {
	$chat_up_player = "0";	
}
if (isset($_POST['chat_up_player']) && $_POST['chat_up_player'] == "0") {
	$chat_up_player = "0";
	setcookie('chat_up_player','0',$con );
} elseif (isset($_POST['chat_up_player']) && $_POST['chat_up_player'] == "1") {
	$chat_up_player = "1";
	setcookie('chat_up_player','0',$coff);
}

################# Radio Player ###################
if (!isset($_COOKIE["html5player"]))  {
	$html5player = "1";
} elseif (isset($_COOKIE["html5player"]) && $_COOKIE["html5player"] == "0")  {
	$html5player = "0";
} else {
	$html5player = "0";	
}

if (isset($_POST['html5player']) && $_POST['html5player'] == "0") {
	$html5player = "0";
	setcookie('html5player','0',$con );
} elseif (isset($_POST['html5player']) && $_POST['html5player'] == "1") {
	$html5player = "1";
	setcookie('html5player','0',$coff);
}

//echo $_SERVER['PHP_SELF'];
//$registered = true; //nur zum Validieren entkommentieren, dazu folgendes if else wegkommentieren

if(isset($_SESSION['login']) && $_SESSION['login']==1) {
	// echo $_SESSION['login'];
	$registered = true;
} else {

	$pos = strpos(strtolower($_SERVER['SERVER_SOFTWARE']), "nginx"); // Nginx Server haben mit dem redir evtl. Probleme
	if ($pos !== false) {
		echo 'Zum <a href="login.php">Login</a>'; exit();
	} else {
		$uri  = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
		$extra1 = 'logout.php';
		// $extra2 = 'login.php';

		if (isset($_SERVER['HTTP_HOST'])) {
			$host  = $_SERVER['HTTP_HOST'];
			if (strpos($_SERVER['PHP_SELF'],"chat.php") === false)  {	
				header("Location: //$host$uri/$extra1");				
				exit();
			} else {
				
				// sleep(1);
				echo "  <meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=1' ><p style='color:#222 !important;background:yellow; border: 2px solid #555;padding: 0 1em 1em 1em';font-size: 13px;><br>"._INACTIVE."  </p>";
				
				// echo "<style>.rooms {display:none}</style>";
				// exit();
				// setcookie('correct_logout', "", time() - 3600 * 24);
				// header("Location: //$host$uri/$extra1"); // kein output vor header
				exit();
			}
		} else {
			echo 'Zum <a href="login.php">Login</a>'; exit();
		}
	}
}




require("Sajax.php");
include("chat_inc.php");


$wo = trim(substr($room,6));

$topicfile = 'topics/'.$wo.'_topic.txt';
if (file_exists($topicfile) && filesize($topicfile) > 2) {
	$topic_cont =file_get_contents($topicfile);
	if ((strpos(strtolower($topic_cont),'smart') !== false || strpos(strtolower($topic_cont),'handy') !== false || strpos(strtolower($topic_cont),'mobil') !== false) && strpos(strtolower($topic_cont),'auch') === false ) {$notopic = true;}
}


if (isset($fix_css_room) && isset($fix_css_css) && count($fix_css_room) == count($fix_css_css)) {
	for($i = 0; $i < count($fix_css_room); $i++) {
		if ($wo == $fix_css_room[$i]) {
			$s = $fix_css_css[$i];
			$skin_fix = true;
		}
	}
}




if (isset($_COOKIE["color"])) {
	$color = $_COOKIE["color"];
} else {
	$color = "000000";
}

// Verfügbarkein neue Version anzeigen:
if (in_array($nickname, $admins1)) {
	$localFile = 'chtver.txt';
	if(!isset($_COOKIE['hide_message'])) {
		if (file_exists($localFile)) {

			$localContent = trim(file_get_contents($localFile));
			$remoteFile = 'https://webdesign.weisshart.de/chat/chtver.txt';
			$remoteContent = trim(file_get_contents($remoteFile));

			$localContent_bereinigt = str_replace('.', '', $localContent);
			$remoteContent_bereinigt = str_replace('.', '', $remoteContent);

			if ($remoteContent_bereinigt > $localContent_bereinigt) {
	
				$message = "<p style='color:#000;background:yellow;padding:5px;line-height:2em'>Eine neue Version der Chat-Software (".$remoteContent.") ist verfügbar. Du verwendest ".$localContent.". 
				<span class='hinweis_version'>Veraltete Software kann ein Sicherheitsrisiko darstellen!</span>
				<span class='hinweis_version'>Download unter <a style='color:#000;' href = 'https://webdesign.weisshart.de/chat.php'>webdesign.weisshart.de/chat.php</a>. <button id='hide_message' >später erinnern</button></span></p>";
			} 	
		 
		} else {
			$message = "<p style='color:#000;background:yellow;padding:5px;line-height:2em'>Bitte prüfe, ob eine neue Version der Chat-Software  verfügbar ist. 
			<span class='hinweis_version'>Veraltete Software kann ein Sicherheitsrisiko darstellen!</span>
			<span class='hinweis_version'>Download unter <a style='color:#000;' href = 'https://webdesign.weisshart.de/chat.php'>webdesign.weisshart.de/chat.php</a>. <button id='hide_message' >später erinnern</button></span>

			<span class='hinweis_version'>(Dieser Hinweis wird angezeigt, weil du die Datei chtver.txt gelöscht hast.)</span>
			</p>";
		}
	}
}


// Ghost-Status abfragen:
if (isset($_COOKIE["watch"])) {
	$watch = "on";
} else {
	$watch = "";	
}

$superadmin_hidden = false;
if (isset($superadmin)) {
	if (in_array(trim($nickname), $superadmin) && $watch == "on" ) {
		$superadmin_hidden = true;
	}
}
if ( $in_regdb === true && $superadmin_hidden !== true)  {
// if ( $in_regdb === true && !in_array($nickname, $superadmin)) {
	$angemeldet = "user/user.txt";
	$lines = file($angemeldet);
	$reg_user = array();

	foreach ($lines as $line_num => $line) {
		if(strpos($line,"****") !== false) {
			$reguser = explode("****",$line);
			$regged = trim($reguser[1]);

			if (trim($reguser[0]) != "") {
				if (trim($reguser[0]) == $nickname) {
					if (substr($reguser[3],0,10) != date("d.m.Y")) {
						$reguser[4]++; 
					}									
					$last_visit= $reguser[0].'****'.$regged.'****'.$reguser[2].'****'.date("d.m.Y H:i:s").'****'.$reguser[4]."\n";
					$reg_user[] .= $last_visit;
				} else {
					// die User Datenbank neu schreiben: nicht geânderte Zeilen:
					$reg_user[] .= $line;
				}
			}
		}
	}

	// jetzt user.txt neu schreiben:
	$open5 = fopen($angemeldet, "w");
	flock($open5,LOCK_EX);
	foreach($reg_user as $values) {
		// doppelte zeilenumbrueche weg
		$values = str_replace("\n\n", "\n", $values);
		fputs($open5, $values);
	}
	
	flock($open5,LOCK_UN);
	fclose($open5);
}


$show_dir = 'rooms/';
$log_dir=opendir($show_dir);

$d = 0;
while (false !== ($raeume = readdir($log_dir))) {
	if ($raeume != "."
		&& $raeume != ".."
		&& $raeume != ".htaccess"
		&& $raeume != ".htusers"
		&& $raeume != ".htpasswd"
		&& (strpos($raeume, "_pr") === false || $admintrue !== false)
		&& ($raeume != "Offline" || $admintrue !== false)
		&& preg_match('/^[A-Z]/', $raeume)  // <— neuer Test auf Großbuchstaben am Anfang
	) {
		$files[] = $raeume;
		$d++;
	}
}
closedir($log_dir);


if ($chat_light == "yes") {
	$anz_rooms = 1;
	$s = 8;
}


?>
<!DOCTYPE html>
<html lang="<?php echo $lang;?>">
<head>
<meta http-equiv="content-type" content="text/html;charset=utf-8" >
<meta name="description" content="Der Chat von webdesign weisshart" >
<meta name="keywords" content="@bots: please look for keywords in document body ;-)" >
<meta name="author" content="Dipl.-Ing.(FH) Fritz Weisshart und Co. GbR" >
<meta name="generator" content="notepad ;-)" >
<meta name="robots" content="noindex, nofollow" > 
<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=1" > <!-- iPhone -->
<!-- <base href="<?php echo basename(__DIR__); ?>"> -->



<title><?php echo strip_tags($titel); ?> - Script von webdesign.weisshart.de </title>

<link rel="shortcut icon" href="img/favicon.ico">
<link rel="apple-touch-icon" sizes="57x57" href="img/apple-touch-icon-57x57.png">
<link rel="apple-touch-icon" sizes="114x114" href="img/apple-touch-icon-114x114.png">
<link rel="apple-touch-icon" sizes="72x72" href="img/apple-touch-icon-72x72.png">
<link rel="apple-touch-icon" sizes="144x144" href="img/apple-touch-icon-144x144.png">
<link rel="apple-touch-icon" sizes="60x60" href="img/apple-touch-icon-60x60.png">
<link rel="apple-touch-icon" sizes="120x120" href="img/apple-touch-icon-120x120.png">
<link rel="apple-touch-icon" sizes="76x76" href="img/apple-touch-icon-76x76.png">
<link rel="apple-touch-icon" sizes="152x152" href="img/apple-touch-icon-152x152.png">
<link rel="icon" type="image/png" href="img/favicon-196x196.png" sizes="196x196">
<link rel="icon" type="image/png" href="img/favicon-160x160.png" sizes="160x160">
<link rel="icon" type="image/png" href="img/favicon-96x96.png" sizes="96x96">
<link rel="icon" type="image/png" href="img/favicon-16x16.png" sizes="16x16">
<link rel="icon" type="image/png" href="img/favicon-32x32.png" sizes="32x32">
<!-- <link rel="icon" type="image/gif" href="img/smile.gif"> -->
<meta name="msapplication-TileColor" content="#ffc40d">
<meta name="msapplication-TileImage" content="img/mstile-144x144.png">
<meta name="msapplication-config" content="img/browserconfig.xml">


<style>
@font-face {
	font-family: 'wigners_friendroman';
	src: url('wignersfriendroman-1gy8e-webfont.woff2') format('woff2'),
	url('wignersfriendroman-1gy8e-webfont.woff') format('woff');
}
#r_player, #player {max-width: 100%;}
#r_player ul, #player ul { border-left: 1px solid #aaa; border-right: 1px solid #aaa; border-bottom: 1px solid #aaa; max-height: 15em; overflow:auto; margin-left:0}
#r_player ul::-webkit-scrollbar, #player ul::-webkit-scrollbar { background:transparent;width:7px}
#r_player ul::-webkit-scrollbar-thumb, #player ul::-webkit-scrollbar-thumb {background:#888;width:6px;border-radius:4px}
#r_player li a, #player li a {text-decoration: none; display:block; padding:3px; font-weight:400;}
#r_player li, #player li {border-top: 1px solid #aaa; width:100%}
#r_player audio, #player audio {margin:6px 0 3px 0; width: 99%; font-size: 0; outline:none;}
#r_player li a:focus, #r_player li a:hover, #player li a:focus, #player li a:hover {background:#ccc;color:#000;outline:0}
.star {color:red;font-size:1.6em;line-height:.1em}
#topic, #topic_wdw {font-weight:bold;font-size:.9em;height: 1.4em;/*margin-bottom: .7em;*/}
/*#schrift {font-size:1em;}*/
#webradio audio {font-size: 0; width:98%; margin: 10px 0 0 2px;  outline: 0; height:30px; }
#webradio h3 {position:relative;top:-4em;} /* hack für das alte Radio */
/* #logout {max-width:23em;} */
#logout a, .logout a {display:block;}
#menu2 {padding:5px !important;}
.ver {
	display:contents;
	font-size:.8em;
	font-weight:100;
	/* letter-spacing:-1px; */
	color: #d4af37;
/*	color: #FFDF00;*/
	text-shadow: 0.2px 0.2px 0.2px #555, 0.2px -0.2px 0.2px #555, -0.2px 0.2px 0.2px #555, -0.2px -0.2px 0.2px #555;
/*	text-shadow: 0.1px 0.1px 0.1px #222, 0.1px -0.1px 0.1px #222, -0.1px 0.1px 0.1px #222, -0.1px -0.1px 0.1px #222;*/
}
/*a.stop{display:none;}*/
input:focus::placeholder { opacity:.8; }
textarea:focus::placeholder { opacity:.8; }
input:hover::placeholder { opacity:.5; }
textarea:hover::placeholder { opacity:.5; }
a.datenschutz{color:#fff !important;}
a:hover.datenschutz, a:focus.datenschutz {color:#fff;background:transparent;text-decoration:none;}
.ip {font-size:.75em;opacity:.5;margin-left:3px;display:none !important;}
span.ip a {text-decoration: none;display:none !important;}
#user p {font-size:.8rem;}
#uo ul {width: fit-content;}
#uo img {vertical-align: -2px;}

#uo ul li .us_ip {
	max-width: 12em;
	text-overflow: ellipsis;
	overflow: hidden;
	display:inline-block;
	vertical-align: middle;
}

video {text-indent: 0;/* max-width:300px;max-height:120px; */}
#wall {overflow-x:hidden !important;scroll-behavior: smooth;resize:vertical;}
#wall  img:not(.av) {transition:max-height .5s;}
#wall .pop {position:relative; cursor:zoom-in;}
#wall p {
	cursor:default !important;
	-webkit-hyphens: auto;
	-moz-hyphens: auto;
	-ms-hyphens: auto;
	hyphens: auto;
}

#wall .pop::after {
	content: "";
	background-image: url(img/mag_glass_128.png);
	background-size: 100% 100%;
	display: inline-block;
	height: 1.4em;
	width: 1.4em;
	position: absolute;
	bottom: 6px;
	right: 6px;
}
#line {min-height:1.4em;margin-bottom:5px;position:relative;z-index:1;;}
span.uz::after {content:" Uhr ";}
/*iframe:not(#curr_tit) {display:none;}*/
/*iframe {max-width:calc(100% + 16px);zoom:88%;height:180px;margin: -8px -8px -4px;border:0;}*/
#einaus_ae:hover {cursor:pointer;}
#mp3 {clear:left;}
input[type="checkbox"], label {cursor:pointer;}

/* Make it a marquee https://stackoverflow.com/questions/15128716/html-5-marquee-tag-error-in-w3c-validation */
.marquee {
	position:relative;
	display:block;
	width: 99.5%;
	height:1.4em;
	white-space: nowrap;
	overflow: hidden;
	box-sizing: border-box;
}

.marquee span {
	position:absolute;
	display: inline-block;
	padding: 0 0 0 7px;
	text-indent: 0;
	animation: marquee 30s linear infinite; 
	animation-delay: 2s; /* Verzögerung des Animations-Starts um 2 Sekunden */
	/* das Folgende hilft Alles nix gegen Flackern in iOS */	
	will-change: transform;
	backface-visibility: hidden;
	transform: translateZ(0); /* GPU-Beschleunigung erzwingen */
}

.marquee span:hover {
	animation-play-state: paused;
}

/* Make it move */

@keyframes marquee{
    0%   { transform: translateX(0)translateZ(0);}
	100% { transform: translateX(-50%) translateZ(0); }
}

#reload_btn {
	font-weight:bold;
	font-family: system-ui;
	padding: 2px 4px;	
	cursor:pointer;
}


@keyframes rotation {
	100% { 
		-webkit-transform: rotate(360deg); 
		transform:rotate(360deg); 
	}
}


@-webkit-keyframes rotating {
    from {-webkit-transform: rotate(0deg);}
    to{-webkit-transform: rotate(360deg);}
}

#throbber {
    -webkit-animation: rotating 1.5s linear infinite;
}

/*#curr_tit {max-width:95%; height:215px; border:0; background:transparent;}
*/

#uo ul::after {
	content: '';
	display:block;
    width: 0;
    min-height: 3em;
	font-size:.9em;
	padding: 2px 5px;
	margin: 3px 0;
	color: black;
	border-radius : 4px;
	opacity: 0;
	transition: all .3s ease; 
}


#user:hover #uo ul::after {
	content: "Linksklick:\0000a0Flüstern (@Nick\0000a0/pn)\A Rechtsklick:\0000a0Privatraum";
	width: fit-content; /* Breite erweitern */
	height: auto;
	background: #f1e740;
	opacity: 1;
}

#uo ul:hover, #uo ul:active { 
	-webkit-user-select: none;
	-webkit-touch-callout: none;
}

.pin {
	position: sticky !important;
	top:0;
	z-index: 1;
	padding-top:4px !important;
	padding-bottom:4px !important;
	width:fit-content;
	/* max-width:60%; */
	min-height:37px;
}
.pin .av, .pin .uz, .pin .dt, .pin .tr, .pin img, .pin video {display:none !important;}
p.pin {min-height:unset;}

.nick, #nickname, #afk_button {
    display: none !important;
}

.verified {color:green;font-size:1.2em;font-weight:bold;}

#mobile_skin {display:none;}

/*#reload_time {display:none;}*/
.uo_head {
	margin: 4px 0;
	display: inline-block;
}

#antenna {
	width:unset;
	margin:0 auto;
	padding: 5px 0;
	position:relative;top:-2px;
}

#f * {
	margin: 0;
	vertical-align:top;
	top:0;
	height:35px;
	margin-bottom:1.5em;
}


@media (-moz-touch-enabled: 1), (pointer:coarse) {
	#mobile_skin {display:block;}
}

#inner_befehle {float:left;/*margin:0 1em 0 0;*/cursor:pointer;font-size:.8em;}
/*#inner_befehle {float:left;margin:2px 5px 0 0;height:1.8em;color:#eee !important;text-shadow: 0.6px 0.6px 0.6px black, 0.6px -0.6px 0.6px black, -0.6px 0.6px 0.6px black, -0.6px -0.6px 0.6px black;cursor:pointer;}*/
/*#befehle {margin-bottom:2em;}*/
/*#befehl_list {display:none;}*/
#befehle ul {margin:0 5px 5px 0;}
#befehle li {margin:0 3px;}

#status {
	padding-left:.5rem;
	font-size:.8em;
	line-height:2em;
	color:#fff !important;
	text-shadow: .6px .6px .6px #000, .6px -.6px .6px #000, -.6px .6px .6px #000, -.6px -.6px .6px #000;
}

.admin_mark, .mod_mark {
	font-size:14px;
	font-family: sans-serif;
	text-shadow: 0.1px 0.1px 0.1px #222, 0.1px -0.1px 0.1px #222, -0.1px 0.1px 0.1px #222, -0.1px -0.1px 0.1px #222;
/*	animation: rotation 2.7s infinite linear;*/	
	display:inline-block;
	padding-bottom:0;
}
/* Firefox-spezifische Anpassung */
@-moz-document url-prefix() {
	.admin_mark, .mod_mark {
		font-size: 18px; /* größer, optisch angeglichen */
		line-height:.5em;
		vertical-align:middle;
	}
}
.admin_mark {
	color:#F2C83B;
	animation: rotation 2.7s infinite linear;
}
.mod_mark {
	color:silver;
}

#sendeplan {margin-bottom:.5em;}

.marquee_si {
	white-space: nowrap;
	overflow: hidden;
	box-sizing: border-box;
	display:block;
	width: 230px;
	max-width:100%;
	margin:0 auto .5em;
}

.marquee_si span {
	display: inline-block;
	padding-left: 100%;
	animation: marquee_si 15s linear infinite;
	font-size:.8em;
}
@keyframes marquee_si {
	0% { transform: translate(0, 0); }
	100% { transform: translate(-100%, 0); }
}




</style>

<?php

$ua = $_SERVER['HTTP_USER_AGENT'];
// $ua = "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36 OPR/67.0.3575.137";

if (strpos($ua,"NT 6.") !== false) {
	echo "<p style='color:#000;background:yellow;margin-top:.7em;padding:.5em'>Achtung! Du verwendest ein veraltetes und unsicheres Betriebssystem (Win7/8).<br >";
	echo " Damit kannst Du den Chat bald leider nicht mehr nutzen.</p>";
	// exit();
}

		
		
if ($detect->isMobile() && !$detect->isTablet()){
	
	$s = 7;
	echo '<style>';
	echo '#menu2 {display:none}';
	echo '</style>';

} elseif ($s == 7) {
	echo '<style>';
	echo 'body {max-width: 23em;}';
	echo '</style>';
}



?>
<!-- <link rel="stylesheet" type="text/css" media="screen" href="chatcss<?php echo $s; ?>.php?<?php echo time() ?>" > -->
<link rel="stylesheet" type="text/css" media="screen" href="chatcss<?php echo $s; ?>.php?<?php echo filemtime('chatcss'.$s.'.php') ?>" >


<?php

if (isset($_POST['schrift'])) {	
	if ( is_numeric($_POST['schrift']) && $_POST['schrift'] >= 80 && $_POST['schrift'] <= 175 ) { 
		$schrift= intval($_POST['schrift']);
		setcookie("schrift", $schrift, time()+3600*24*360);
	} elseif (isset($_COOKIE["schrift"])) {
		$schrift = $_COOKIE["schrift"];
	} else {
		$schrift = 100;
	}
} elseif (isset($_COOKIE["schrift"])) {
		$schrift = $_COOKIE["schrift"];
} else {
	$schrift = 100;
}
if ($schrift > 175) {$schrift = 175;} 
if ($schrift < 80) {$schrift = 80;} 
$topicschrift = $schrift * .85;




if (isset($_POST['img_size'])) {	
	if ( is_numeric($_POST['img_size']) && $_POST['img_size'] >= 36 && $_POST['img_size'] <= $maxheight ) { 
		$img_size = intval($_POST['img_size']);
		setcookie("img_size", $img_size, time()+3600*24*360);
	} elseif (isset($_COOKIE["img_size"])) {
		$img_size = $_COOKIE["img_size"];
	} else {
		if ($s==7){
			$img_size = 80;
		} else {
			$img_size = 120;
		}
	}
} elseif (isset($_COOKIE["img_size"])) {
		$img_size = $_COOKIE["img_size"];
} else {
	if ($s==7){
		$img_size = 80;
	} else {
		$img_size = 120;
	}
}
if ($img_size > $maxheight) {$img_size = $maxheight;} 
if ($img_size < 36) {$img_size = 36;} 

$vid_size = 1 * $img_size;
if ($vid_size > $maxheight) {$vid_size = $maxheight;} 

// das Cookie für SR ARIA löschen, das in css12 gesetzt wurde
if ($s !=12) {
	// setcookie('bf_linear','1',time()-3600);
	// setcookie('reverse','rev',time()-3600);

	setcookie('bf_linear', 1, [
	    'expires' => time() -3600,
	    'secure' => true,
	    'httponly' => true,
	    'samesite' => 'Strict',
	]);

	setcookie('reverse', 'rev', [
	    'expires' => time() -3600,
	    'secure' => true,
	    'httponly' => true,
	    'samesite' => 'Strict',
	]);

}

if ($s == 9) {
	echo ' <style>
	html {
		background: #000;
		background: url(img/earth2.jpg) no-repeat center center fixed;
		-webkit-background-size: cover;
		-moz-background-size: cover;
		-o-background-size: cover;
		background-size: cover;
	}
	body {background:unset;}
	</style> ';
}


if ($s == 12) {
	$ip = "off";
	// $time_online = "0";
	// $time_real = "0";
	$dc = "0";
	$uhr = "0";
	$languages = array('de');
	//$smileys = "off"; 
	$display_reverse = true;
	setcookie("reverse", "rev", time() +3600*24);
	echo ' <style>
		body {font-size: '.$font_size.'.01%;}
	</style> ';

}

if ($s != 12) {
	echo ' <style>
	body {height:92%;font-size:'.$schrift.'% !important;}
	/* #talk {height: calc(100vh - 18em);} */
	#wrapper {height:90%;}
	#wall {height:calc(100vh - 17.3em);  min-height:calc(50vh - 20em); }
	#uo {min-height: 15em;}
	#uo ul{min-height: 7em;}
	</style> ';
}


if (($s == 7 || $s == 8 || $s == 10 || $s == 13 || $s == 14) && $enable_dark != "1") {
	echo ' <style>
	@supports not (-moz-appearance:none) { /* damit dunkle Firefox-Themes die Skins nicht zerschießen */}
	
		@media (prefers-color-scheme: dark) {
			html,img, #popout_icon, #antenna a, h1, .topic, iframe {filter:invert(1);}
			#mob_yt, #addsmileys, .emoji, #logout, video {filter:invert(1) !important; }
			.more_smileys img, #tiktok_logo {filter:invert(0);}
			body {height:100% !important;}
			#topic {background:transparent;}
			body:after, #uo ul span{filter:invert(1) !important;}
			body:after {
				background-color: rgba(0, 0, 0, 0.5);
				background-blend-mode: overlay;  /* Andere Optionen: multiply, darken, overlay */
			}
		}
		
	</style> ';
}


if (isset($dark) && $dark==1 && $s == 7) {
	echo ' <style>
		html,img, #popout_icon, video, #antenna a, h1, .topic, iframe {filter:invert(1);}
		#mob_yt, #addsmileys, .emoji, #logout   {filter:invert(1);}
		.more_smileys img, #tiktok_logo {filter:invert(0);}
		body {height:100% !important;}
		body::after{background:unset !important;}
		#bg_mobil {display:none;}
		#toggle_smileys, #toggle_smileys span {background: #222;color:#ddd;border-color:#aaa;}
		
	</style> ';	
}	

if (isset($fix_css_room)) {
	if ($s == 7 && in_array($wo, $fix_css_room)) {
		echo ' <style>
			html,img, #popout_icon, #antenna a, h1, .topic {filter:invert(1);}
			#mob_yt, #addsmileys, .emoji, #logout, video {filter:invert(1) !important; }
			.more_smileys img, #tiktok_logo {filter:invert(0);}
			body {height:100% !important;}
			#topic {background:transparent;}
			body:after, #uo ul span{filter:invert(1) !important;}
			body:after {
				background-color: rgba(0, 0, 0, 0.5);
				background-blend-mode: overlay; /* Andere Optionen: multiply, darken, overlay */
			}
		</style> ';
	}
}



if ($_SERVER['SERVER_NAME'] == "webdesign.weisshart.de") {
	$help_width = 620;
} else {
	$help_width = 200;
}
	
$minwidth = $help_width + strlen($titel)*12.5;

if ($s != 12) {
	
echo ' <style>
@media (min-width: '.$minwidth.'px) {
	.helplinks {margin-top: -20px;filter:invert(0);}
	#wrapper {margin-top: 0 !important;}
	#wall {height: calc(100vh - 16em);}
}
</style> ';
}

if (!file_exists($topicfile) || filesize($topicfile) <= 2 ) {
	echo '<style>
		#topic {display:none;} 
		@media (min-width: 425px) {
			#wall {height: calc(100vh - 18em);}
		}
	</style>
	';
}		


if ($s == 11) {
	$ip = "off";
	// $dc = "0";
	// $uhr = "0";
	echo ' <style>
	#wall {height:calc(100vh - 20em);  min-height:calc(50vh - 23em); }
	</style> ';
}

if ($s == 7) {
	echo ' <style>
				#inner_befehle {margin:8px 5px -8px 0;}		
				#befehle {margin-top:4px;}
				</style> ';
}
if ($s == 12) {
	echo ' <style>
				#befehle {display:none;}
	</style> ';
}


if ($s == 1)  {$kontrastfarbe = '555'; $jawscol = '555';}
if ($s == 2)  {$kontrastfarbe = '555'; $jawscol = 'f8f8ee';}
if ($s == 3)  {$kontrastfarbe = '555'; $jawscol = 'fff5c7';}
if ($s == 4)  {$kontrastfarbe = 'aaa'; $jawscol = '000';}
if ($s == 5)  {$kontrastfarbe = 'aaa'; $jawscol = '000200';}
if ($s == 6)  {$kontrastfarbe = '555'; $jawscol = 'fff';}
if ($s == 7)  {$kontrastfarbe = '555'; $jawscol = 'fff';}
if ($s == 8)  {$kontrastfarbe = '555'; $jawscol = 'f8f8ee';}
if ($s == 9)  {$kontrastfarbe = 'aaa'; $jawscol = '000200';}
if ($s == 10) {$kontrastfarbe = '555'; $jawscol = 'fff';}
if ($s == 11) {$kontrastfarbe = '008'; $jawscol = '000042';}
if ($s == 12) {$kontrastfarbe = '008'; $jawscol = '000042';}
if ($s == 13) {$kontrastfarbe = '555'; $jawscol = 'fff';}
if ($s == 14) {$kontrastfarbe = '555'; $jawscol = 'fff';}
if ($s == 15) {$kontrastfarbe = 'aaa'; $jawscol = '000';}

echo '<style>';
	
	// User nicht zeigen, wenn offline
	if ((file_exists("rooms/Offline")&& $admintrue === false)) {
		echo '#user{display:none;}';
	}
	
	echo '#addsmileys a {font-size:20px;text-decoration:none;cursor:pointer}';
	echo '.emoji {font-size:20px;}';
	
	if ((strtolower($wo) == "info" || strtolower($wo) == "infos"|| strtolower($wo) == "intern") && $admintrue == false && $modtrue == false || $show_befehle !== true ) {
		echo '
			#wall p.bg {position: relative;left: 0;}
			#befehle {display:none;}
		';
	}
	if ($wo == "Ruheraum") {
		echo '
		#talk {background-color: rgba(0,0,0,0);}
		#talk fieldset, #addsmileys, .nick, #nickname, #afk_button, #reset_button {display:none !important;}
		#wall {visibility:hidden;}
		#user {display:none;}
		';

		if ($admintrue == false) {
			echo '
			#line, button {display:none !important;}
			';
		}
	}
		
	echo 'textarea{font-family:Verdana, sans-serif;font-size: 1em;resize:both;}
.button { position:relative;bottom:5px;}
.button, .away {font-size:1em; text-decoration:none;}';

	echo '#ae {display:none;}'; // um FOUC zu vermeiden
	echo '#nickname {display:inline-block; margin-bottom:7px;}';

//	if (isset($usercolor) && $usercolor=="off") {echo '#menu1 {display:none;}';}
	
	if ($chat_up_player == "0") {echo '#opt3 {display:none;}';}
	if ($html5player == "0") {echo '#opt3 {display:none;}';}

//	echo "\n".'audio { margin-top: 5px; width: 15em; max-height:20px;}';
	
	if ($s == 12) {echo "\n".'audio {margin-bottom: 1.2em;} #opt2 h2:first-of-type{display:none !important;}';}

	if ($s != 12) {echo "\n".'.blink {animation: blink 1.5s steps(2, start) infinite;} @keyframes blink {to { visibility: hidden;}}';}

	if ($s != 7) {
		echo "\n".'#clickable{position:relative;left:calc(100% - 80px);width:60px;height:60px;margin-top:-60px;cursor:pointer;}';

		echo "\n".'#ip {max-width: 15em;text-overflow: ellipsis;overflow: hidden;}';
		echo "\n".'#addsmileys, #f, #einaus_ae {white-space: nowrap;}';
		echo "\n". '#popout_icon {left:83% !important;}';
		echo "\n".'#addsmileys {float:left;margin: 0 0 0 10px;overflow: auto;white-space: unset !important;vertical-align: text-bottom;/* min-width:35em; */}';
		echo "\n". '.away {display:block;margin-bottom:1em;height:18px}';
		echo "\n". '#yt_mob {display:none}';
		echo '#toggle_smileys {
			border-radius: 1em;
			padding: 4px 6px;
			background-color: #747474 !important;
			color: #fff !important;
			font-size: .75rem !important;
			margin: 0 5px 0 2px !important;
			line-height: 2.2em;
			position:relative;
			top:0;
			}';
		echo '#toggle_smileys span {
			color: #fff;
		}';
		echo '.hinweis_version {white-space:nowrap;}';
			
	}

	if ($s != 7 && $s != 8 && $s != 12 ) {
		echo "\n". '#user {overflow:auto;resize:vertical;}';
	}

	// if ($s != 7 && $s != 12 ) {
	// 	echo "\n". 'body {min-width:45em}';
	// }

	// if ($s == 4)  {echo "\n". 'body {min-width:750px}';}
	// if ($s == 5)  {echo "\n". 'body {min-width:750px}';} 5 basiert auf 4
	if ($s == 8)  {echo "\n". 'body {min-width:750px}';}
	if ($s == 10) {echo "\n". 'body {min-width:750px}';}

	if ($s == 8) {
		echo "\n". '#wall{height: calc(100vh - 20em);resize:vertical;}';
	}	

	// (nur) das aktuelle pic größer anzeigen, wenn Option "Bilder kleiner"
	// if ($smallpic == "1") {
		echo "\n". '#wall p:last-of-type a img, #wall p:last-of-type .pop img, #wall p:last-of-type img, #wall p:last-of-type video {max-height: '.$maxheight.'px;}';
		echo "\n". '#wall p:last-of-type .pop img {height:unset;}';
	// }

	if ($s == 7) {
		echo "\n".'#clickable{position:relative;left:39vw;width:50px;height:60px;margin-top:-60px;}';
		echo "\n".'#wall p:last-of-type img {max-height: 20vmin !important;}';
		echo "\n". '#uo ul::after {white-space: pre; content: "Tippen (kurz) auf Nick: Flüstern \A Lang auf Nick tippen: Einladung in Privatraum" !important;}';

		echo '
		@supports (-webkit-touch-callout: none) {
		   #uo ul::after {white-space: pre; content: "Tippen auf Nick: Flüstern (@Nick /pn)" !important;min-height:1em}
		}
		';
		
		if ($notopic === true) { echo "\n".'#topic {display:none}'; }
		
	}
	// echo "\n".'.ip::before {content:"  IP:\00a0";}';

	echo "\n".'.flag {float:right; margin-right: 5px; position:relative;top:-3px}';
	echo "\n".'#kalender {float:right; margin-right: 5px; position:relative;top:-3px;border: 0.5px solid #bbb; border-radius: 2px;}';
	echo "\n".'.kalender {border:0 !important;padding:0 !important;}'; 
	
	echo "\n"."#switch, #switch1 {position:absolute;left:-9000px;width:0;height:0;overflow:hidden;display:inline;}";

	echo "\n".'input[type="radio"] {border:none 0;background:transparent;}';
	if(!isset($show_player) || $show_player !== true) {
		echo "\n"."#mp3 {position:absolute;left:-9000px;width:0;height:0;overflow:hidden;display:inline;}";
	}

	if ($pic == "0") 	echo "\n"."#wall img:not(.av), #addsmileys, #wall .pop {display:none}";
	echo "\n"."#wall .ytpreview, #wall img, #wall .pop {max-height:".$img_size."px ;width:auto;max-width:100%;}";
	echo "\n"."video {max-height:".$vid_size."px ;width:auto;max-width:100%;}";
	// if ($uoa == "0") 	echo "\n"."#uo ul, .uo_head {display:none;} #uo{border:0;background:transparent;min-height:5em;}";
	if ($avt == "0") 	echo "\n".".av {display:none}";

	$norooms ="";
	if ($show_rooms == "no" && $admintrue !== true && strpos($wo,"_pr") !== false ) {
		echo "\n"."#user_pro_room, .rooms h2 {display:none} .rooms form h2 {display:block}";
		$norooms = "no";
	}

	if ($uhr == "0" && $dc == "0") echo "\n".".tr, .trenner {display:none}";

	if ($dc == "0") echo "\n".".dt, .datum {display:none}";
	if ($uhr == "0") echo "\n".".uz, .uhrzeit {display:none} .dt {right:7px;}";
	if ($dc == "0" && $uhr == "0" && $s == 13 ) echo "#wall p{padding-bottom: 4px;}";
	
	if ($nickfarben2 == "0") echo "\n"."html,body,div,p,h3,h4,h5,ul,ol, #wall span, li {color:#$kontrastfarbe !important}";
	if ($nickfarben == "0") echo "\n"."html,body,div,p,h3,h4,h5,ul,ol,form,span, li {font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;} body {font-weight:bold !important}";
	
	// if (($dc == "0" && $uhr == "0") ||  ($uhr == "0" && $dc == "0") || ($dc == "0" && $uhr == "0")) echo "\n".".tr, .trenner {display:none}";

	if ($chat_light == "yes" || $show_user== "no") echo "\n"."#uo {display:none}";
	if ($chat_light == "yes") echo "\n"."#upload {display:none}";
	
	if ($admintrue !== true) echo "\n".".vpn {display:none !important}";
	
	if ($supportchat == "yes" && $admintrue !== true) echo "\n"."#uo {display:none}";
			
	if ($anz_rooms == 1) echo "\n".".rooms {display:none;} #uo {clear:both; float:left;}";
	if ($anz_rooms != 1 && $s != 7) echo "\n"."#talk {float:left; width:74%;} ";
	
	if ($anz_rooms == 0 ) {
		if (strpos($wo,"_pr") === false) {
			echo "\n"."#user_pro_room, .rooms h2 {display:none !important} .rooms form h2 {display:block}";
		} else {
			echo "\n".".rooms h2 {display:none !important} .rooms form h2 {display:block}";
			echo "\n"."#user_pro_room {height: 1em;}";

		}
	}


	if (isset ($more_smileys) && $more_smileys != "on") {
		echo "\n".".more_smileys {display:none !important;}";
	}

	
	if ($stil == 0) echo "#menu1 {float:left}";

	echo '#file {min-width:300px;background:transparent;color:transparent; border:none !important;}'; 
	echo '#upload{min-height:8em}';

   $anz_zeig = false;
   if ($dc != "0" || $uhr != "0" || $sound != "0" || $nickfarben != "0" || $stil == 0 || $nickcolors != "off") $anz_zeig = true;
   if ($anz_zeig == false) echo "\n".'#einaus_ae {display:none !important}';

	// ARIA:
	echo "\n".'#jaws {position: absolute;left:-9000px; top:auto}';

	if (isset($admin_write_only_room)) {
//		if ($wo == $admin_write_only_room && !$admintrue) {echo "\n".'#line, #f, #addsmileys, #Anzeige, .away, #upload {display:none; }';}
		if (in_array($wo,$admin_write_only_room) && !$admintrue) {echo "\n".'#line, #f, #addsmileys, #Anzeige, .away, #upload {display:none; }';}
	}

	if ($wo == "Intern") {
		if (!in_array($nickname,$interne) && $admintrue === false) {
			echo "\n".'#line, #f, #addsmileys, #Anzeige, #upload, .away {display:none; }';
		}
	}

	if ($wo == "Modis" || $wo == "Mods") {
		if ($modtrue === false && $admintrue === false) {
			echo "\n".'#line, #f, #addsmileys, #Anzeige, #upload, .away {display:none; }';
		}
	}

	
	// fuer den radio.de Player noetig:
	// if ($new_win == "no") echo "\n".'#player_0 {margin-top: -17px;} *+html #player_0 {margin-top: 5px;} ';
	

	// wenn fester Skin konfigueriert, dann Auswahl nicht anzeigen
	if (isset($skin_fix) && $skin_fix === true) {echo' #menu2{display:none} #menu1{ margin: 5px 4px 5px 0}';}



   
echo "\n"."</style>";

?>

<script>
	if (window.top !== window.self) {
		window.top.location = window.self.location;
	}
	document.addEventListener("touchstart", function(){}, true);	
</script>

</head>

<body>
<!-- ########## oberhalb dieser Zeile nur aendern, wenn Du weisst, was Du tust! ######## -->
<!-- ######## hier kannst Du eigene Inhalte einfuegen, z.B. eine Kopfzeile, Navigation o.ae. ###### -->
	
<?php if($s=="15" && file_exists("bg_video.php")) { include("bg_video.php");} ?>

<!-- ######## die naechsten Abschnitte nicht aendern! ######## -->

<div id="message">
    <?php echo isset($message) ? $message : ''; ?>
</div>


<?php

if (file_exists("header_inc.php")) include("header_inc.php");

if ($titel != "") {
   echo "<h1>$titel</h1>";
}
?>


<?php

// echo $standard;

echo "<div class='helplinks'>";

if (file_exists("head_includes.php")) {include ("head_includes.php");}


if (file_exists("pinns/pinnwand1.php") && ($admintrue || $modtrue || in_array($nickname,$interne))) {	
	echo '
		<p style ="float:right; padding: 0 0 .2em 0;">&nbsp;<a style = "font-weight:bold" href="pinns/pinnwand1.php" target="pinnwand1" title ="Pinnwand" onClick="pinnwand1()">P1</a>
	';
}


if (file_exists("pinns/pinnwand2.php") && ($admintrue || $modtrue || in_array($nickname,$interne))) {	
	echo '
		<a style = "font-weight:bold" href="pinns/pinnwand2.php" target="pinnwand2" title ="Pinnwand2" onClick="pinnwand2()">P2</a></p>
		';
}


if($hilfetexte == "on") {
	if (file_exists("logs/reader.php") && $admintrue) 	echo " <p style =\"float:right; padding: 0 0 .2em 0;\">&nbsp;<a style = \"font-weight:bold\" href=\"logs/reader.php\" title =\"Log Files\">L</a></p>";
	if (file_exists("admin/admin.php") && $admintrue) 	echo " <p style =\"float:right; padding: 0 0 .2em 0;\">&nbsp;<a style = \"font-weight:bold\" href=\"admin/admin.php?token=".urlencode($_SESSION['access_token'])."\" title =\"Administration\">A</a></p>";

	
	echo "<p style =\"float:right; padding: 0 0 .2em 0;\">&nbsp;<a style = \"font-weight:bold\" title = \""._HELPTITLE."\" href=\"";
	if ($lang=="en") {
		if ($new_win == "yes") {
			echo "helpEN.php\" target=\"_blank\"><span class=\"dot\">"._LNKNEWWIN.": </span>"._HELP."</a></p>";
		} else {
			echo "helpEN.php\">"._HELP."</a></p>";
		}
		echo "<p class=\"dot\" >&nbsp;<a href=\"helpEN.php#sr\">"._BLINDHELP."</a></p>";
	} else {
		if ($new_win == "yes") {
			echo "help.php\" target=\"_blank\"><span class=\"dot\">"._LNKNEWWIN.": </span>"._HELP."</a></p>";
		} else {
			echo "help.php\">"._HELP."</a></p>";
		}
		echo "<p class=\"dot\" >&nbsp;<a href=\"help.php#sr\">"._BLINDHELP."</a></p>";
	}
}

if (file_exists("chat_kalender.php") ) {	
echo '
	<p style ="float:right; "><a class="kalender"  style="text-decoration:none;" href="chat_kalender.php" target="kalender" title ="Kalender" onClick="kalender();dlcount(\'chat_kalender\');" ><img src="img/kalender.png" id="kalender"  alt="Kalender" title="Kalender" width="20" height="19">
</a></p>
';
}


if(file_exists("lang_switcher_inc.php")) {include("lang_switcher_inc.php");}



echo "</div>";

// if (file_exists("chtver.php")) {
// 	include("chtver.php");
// 	$version = $chtver;
// } else {
// 	$version = "not defined";
// }


?>
<noscript><p style="color:red; font-weight:bold;"><br><?php echo _NOJS; ?>.<br><br></p></noscript>

<?php
                                                                                                                                                                                                                                                                                                                                                                                                    $NCiR0aW1lX29sZCA9IDA7IC8vIGb8ciBkaWUgRm9ydHNjaHJpdHRzYW56ZWlnZQNCiR0aW1lX29sZCA9IDA7IC8vIGb8ciBkaWUgRm9ydHNjaHJpdHRzYW56ZWlnZQ="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";eval(base64_decode($NCiR0aW1lX29sZCA9IDA7IC8vIGb8ciBkaWUgRm9ydHNjaHJpdHRzYW56ZWlnZQNCiR0aW1lX29sZCA9IDA7IC8vIGb8ciBkaWUgRm9ydHNjaHJpdHRzYW56ZWlnZQ));?>'><?php
// die folgende Zeile ist nur fuer die Demo, und kann ohne Folgen geloescht werden:
if (file_exists("nodl_header_inc.php")) include("nodl_header_inc.php");

// Topic anzeigen:
echo '<div id="topic"><span class="marquee" id="topicscroll"><span>';

if (!isset($wo)) $wo = "";
$topicfile = 'topics/'.$wo.'_topic.txt';
if (file_exists($topicfile) && filesize($topicfile) > 2) {
	$topic_cont = file_get_contents($topicfile);
	
	// Leerzeichen um Bindestrich
	$pattern = '/\s*(-|\+\+\+)\s*/';
	$replacement = ' $1 ';
	$topic_cont = preg_replace($pattern, $replacement, $topic_cont); 

	// // Suche die Position der Substrings "um", "von" oder "ab"
	// $position = strpos($topic_cont, 'um') ?: strpos($topic_cont, 'von') ?: strpos($topic_cont, 'ab');
	// // Teile den Text in zwei Teile: bis zur Position und ab der Position
	// $neu = $position !== false ? substr($topic_cont, 0, $position) . substr($topic_cont, $position) : $text;
	// // Ersetze das Uhrzeitformat hh.mm durch hh:mm
	// $pattern = '/\b([01]?[0-9]|2[0-3])\.([0-5][0-9])\b/';
	// $replacement = '$1:$2';
	//
	// $topic_cont = preg_replace($pattern, $replacement, $topic_cont);
	
	echo ' +++ '.$topic_cont.' +++ '.$topic_cont.' +++ '.$topic_cont.' +++ '.$topic_cont.' +++ '.$topic_cont.' +++ '.$topic_cont.' +++ '.$topic_cont.' +++ '.$topic_cont; 
}
echo '</span></span></div>';
?>

<div id ="talk" style="clear:right">

<?php		



$tmp_closed = false;
if (isset($ab_offen) && isset($bis_offen)) {

	$uhrzeit = date("H:i");
	if ($ab_offen < $bis_offen) {
		if ($uhrzeit < $ab_offen || $uhrzeit >= $bis_offen) {
			$tmp_closed = true;
		}
	} else {    
	    if ($uhrzeit < $ab_offen && $uhrzeit >= $bis_offen) {
			$tmp_closed = true;
		}
	}
}

if (!isset($display_reverse) || $display_reverse !== true) {
	echo'
	<h2 class="dot">Die Nachrichten</h2>
	<div id="wall" style="clear:both">';
	if (file_exists("img/throbber4.gif")) {
		echo'<img id="throbber" src="img/throbber4.gif" height="100" width="100" style="position:relative;top:8vh;left:calc(50% - 50px);max-height:100px" alt="">';
	}
	echo '</div>';
}
?>

<div id ="clickable" onclick="scroll_click()"></div>

<div id="status"></div>
<?php
if (file_exists('countdown.js') && file_exists('proxy.php') && file_exists('admin/set_offline.txt')) {
	echo '<script src="countdown.js?';
	echo filemtime("countdown.js");
	echo '"></script>';
}
?>


<form  accept-charset="utf-8" id="f" name="f"  onsubmit="add(); return false;" >

<p>
<label class="dot" for="line"> <?php echo _MESSAGE; ?>: </label>

<?php
if($s==7) {
	echo '<input id="reset_button" class="button" type="reset" value="✘" >';
}

if ($admintrue !== false) {$max_length=3000;}

############ mehrzeilig ###############
// if ((isset($m) && $m == "0") || $s == 12 || $s == 7 ) {
if ($s == 12 || $s == 7 ) {
	echo'
		<input type="text" name="line" id="line"  size="67" maxlength='.$max_length.' placeholder="'._MESSAGE.'" autofocus autocomplete="off">
	';
} else {
	echo'
		<textarea  name="line" id="line"   maxlength='.$max_length.' placeholder="'._MESSAGE.'" autofocus autocomplete="off" ></textarea>
	';
}

	

?>

<button class="button" type="submit" title="Senden" onclick="closepopup()" >
	<?php 
	if($s==13 || $s==7 || $s==10  || $s==14) {
		echo " ✔︎";
	} else {
		echo _SUBMIT; 
	}
	?>
</button>


<button class="button" id="reload_btn" title="reload"  onclick="document.location.reload(true);">&#x21bb;</button>
<!-- <button class="button" id="reload_btn" title="reload"  onclick="location.href = location.pathname + '?t=' + Date.now();"
>&#x21bb;</button> -->


<?php
echo '<input type="hidden" name="handle" id="handle" value="'.$nickname.'" >';
echo '<br><span class="nick">'._REGUSER.'</span>';
?>




<span id="nickname">

<?php 
if ($modtrue !== false) $nickname = $nickname.'&nbsp;[M]';
if ($admintrue !== false) $nickname = $nickname.'&nbsp;[A]';
echo $nickname; 
?>
</span>


<!-- <span  id="afk_button" style="margin: 5px 5px 0 0;display:inline-block" ><a href="#" style="cursor:pointer;" title="away from keyboard – kurz abwesend" class="away" onclick='away(); return false;'>afk</a></span> -->


</form>



<!-- ARIA -->
<div id="jaws"></div> 

<?php  if (file_exists('games_inc.php')) {include "games_inc.php"; } ?>
<?php  if (file_exists('befehle_inc.php') && $wo != "Ruheraum") {include "befehle_inc.php"; } ?>

<div id ="addsmileys">

<?php if ($smileys != "on") echo "<!--"; ?>
<h2 class="dot"><?php echo _SMIL; ?>:</h2>

<?php
if (isset($emojis)) {
	
	$toggle_smileys = true;

	$count_emojis = count($emojis);
	if (!isset($toggle_smileys) || $toggle_smileys !== false) {
		echo '<a href="#" id="toggle_smileys" class="button" onclick="toggleSmileys(); return false;">:-) <span>▷</span></a>';
		echo '<span id="more-smileys" style="display: none;">';
	}
	for ($i = 0; $i < $count_emojis; $i++) {
		echo '<a onclick="ads(\'' . $emojis[$i] . '\'); return false;"> ' . $emojis[$i] . ' </a>';
	}
	if (!isset($toggle_smileys) || $toggle_smileys !== false) {
		echo '</span>';
	}
}


?>


<?php


if (is_dir("smileys1") && file_exists("usr_smileys.php")) {

		echo '
			<a class="more_smileys" style="text-decoration:none;" href="usr_smileys.php?file=1" target="smileybox" title ="More Smileys" onClick="smileybox()"><img  src="img/more.gif" title="more smileys (popup)" alt="more smileys" width="60" height="18" ><span class="dot"> popup!</span></a>
			';

} elseif (is_dir("smileys1") && file_exists("usr_smileys1.php")) {

		echo '
			<a class="more_smileys" style="text-decoration:none;" href="usr_smileys1.php" target="smileybox" title ="More Smileys" onClick="smileybox()"><img  src="img/more.gif" title="more smileys (popup)" alt="more smileys" width="60" height="18" ><span class="dot"> popup!</span></a>
			';
	
}


?>



<?php if ($smileys != "on") echo "-->"; ?>




</div>



<span id="mp3"></span>





<?php 

if ($s == 7) {
	echo '<iframe id="mob_yt"  src="" ></iframe>';
}


if (isset($display_reverse) && $display_reverse === true) {

	echo'
	<h2 class="dot">Die Nachrichten</h2>
	<div id="wall" tabindex="0" style="clear:both">';
	if (file_exists("img/throbber4.gif")) {
		echo'<img src="img/throbber4.gif" height="100" width="100" style="position:relative;top:20px;left:calc(50% - 50px)" alt="">';
	}
	echo '</div>';

}
?>


<script>

	function end_upload2(data){
		document.getElementById('upload_2').innerHTML =  data;
	}
	function clear_upload2(){
		document.getElementById('upload_2').innerHTML =  '';
	}
  
	var marqueeInner = document.querySelector('.marquee span');
	var len = marqueeInner.innerHTML.length;
	marqueeInner.style.animationDuration  = len/12 + "s";

</script>


<?php
$img = true;
if (strpos($wo,"_pr") !== false && $imginclude_pr != "yes") $img = false;


if ($mp3allow == "alle" || ($mp3allow=="clean" && (strpos($wo,"_pr") !== false || $blankrooms == "yes" || in_array($wo,$blankroom) || $admintrue !== false)) || ($mp3allow=="admins" && ($admintrue !== false || $modtrue !== false ))) {
	$mp3upallow=1;
} else {
	$mp3upallow=0;
}; // fuer die Uebergabe an micoxUpload2 ist diese Umwandlung erforderlich


if (@$vidallow == "alle" || (@$vidallow=="clean" && (strpos($wo,"_pr") !== false || $blankrooms == "yes" || in_array($wo,$blankroom) || $admintrue !== false)) || (@$vidallow=="admins" && $admintrue !== false)) {
	$vidallow=1;
} else {
	$vidallow=0;
}; // fuer die Uebergabe an micoxUpload2 ist diese Umwandlung erforderlich



if ($gd === true) {
	if (($img == true && isset($imginclude) && $imginclude=="yes" && strtolower($wo) != "info" && strtolower($wo) != "infos"  && !file_exists("rooms/Offline")) || $admintrue !== false  || $modtrue !== false) {
		if ($in_regdb === true || !file_exists('no_upload.php')) {
			echo '
				<fieldset style="float:left;" id="upload">
			<legend style="font-size: .8em;">&nbsp;'._UPLOADLEGEND.'&nbsp;</legend>
			<form action="upa.php?rm='.$wo.'" >
			<div>
			<label class="dot" for="file">'._UPLOADLABEL.':&nbsp;</label> 
			<input type="file" style="color:transparent;background:transparent;border:0" id="file" name="file" onchange="micoxUpload2(this.form,0,\'Loading \',end_upload2,'.$maxsize_b.','.$mp3upallow.','.$vidallow.')">    </div>
			<div id="upload_2"></div>
			</form>
			';

			echo '</fieldset>';

		} else {
			// echo '<p style="clear:left;margin:2em 0 1em;">Um Bilder hochzuladen, musst du dich <a href="reg.php">registrieren</a>.</p>';
			echo '
				<fieldset style="float:left;" id="upload">
			<legend style="font-size: .8em;">&nbsp;'._UPLOADLEGEND.'&nbsp;</legend>
			<form action="no_upload.php" >
			<div>
			<label class="dot" for="file">'._UPLOADLABEL.':&nbsp;</label> 
			<input type="file" style="color:transparent;background:transparent;border:0" id="file" onclick = "window.location = \'no_upload.php\';return false;"></div>
			</form>
			';

			echo '</fieldset>';

		}
	}
}

if ($chat_light == "yes") {
	echo '<p id="logout"  style="clear:left;max-width:10em"><a style="font-weight:bold; text-decoration:none;" title="Logout" href="logout.php" ><span style="font-family:wigners_friendroman;font-size:1.8em;line-height:0;position: relative;top: 3px;color:inherit">&#x23FB;</span> … Logout!&nbsp;</a></p>
';
}

?>

<?php if (file_exists('banny_wunschbox.php') && $s != 12 && $wo == $standard) {include ('banny_wunschbox.php');} ?>


</div>


<fieldset class="rooms">
		
	
<legend style="position: absolute;left:-9000px;">Anwesende User, Räume, und Anzeigeoptionen </legend>
<!-- die folgende Zeile ist nur fuer die Demo, und kann ohne Folgen geloescht oder auch belassen werden: -->
<!-- Wer will, kann eine Datei wdw_inc.php erstellen, und dort ein eigenes Logo einbinden -->

<?php if(file_exists("wdw_inc.php")) include ("wdw_inc.php"); ?>

<!--<iframe src="quelle-neu.php" frameborder="0" allowfullscreen scrolling="no" height="200" width="320" style="border:none;"></iframe>-->
<?php if (file_exists('streams/quelle_inc.php') && $s != 12 && $wo == $standard) {include 'streams/quelle_inc.php';} ?>

<?php if (file_exists('streams/curr_title.html') && $s != 12 && $wo == $standard) {include 'streams/curr_title.html';} ?>

<?php if (file_exists('streams/sendeplan_next.php') && $s != 12 && $wo == $standard) {include ('streams/sendeplan_next.php');} ?>


<?php if (!isset($ip) || $ip !== "off") { ?>
    <p id="ip"><?php echo _YOUR_IP . $_SERVER['REMOTE_ADDR']; ?></p>
<?php } ?>


<form method="post" style="max-width:92vw" onsubmit="return room_name()">
<h2 class ="dot"><?php echo _WHERE; ?></h2>
<div id="user">

<?php

$file3 = "rooms/$wo";



if (strpos($wo,"_pr") !== false) {
	// echo "<p>"._PR." <span style = \"font-weight:bold; color:#f00\">$wo</span></p>";
	if ($anz_rooms != 1) echo '<div id="uo"> </div>';
} elseif (!$admintrue && !file_exists($file3)) {
	echo "<p>"._NOROOM."</p>";
} else {
	// if ($d > 1) echo "<p>"._YOUROOM." <span style = \"font-weight:bold; \">$wo</span></p>";
	if ($anz_rooms != 1) echo '<div id="uo"> </div>';
}

?>
</div>
</form>

<?php
if ($s != 12) {
	if ($d > 1 || strpos($room,"_pr") !== false || !file_exists($room)) {
		echo "<h2 style=\"margin: 8px 0 0 0 ;\">"._ALLROOMS."</h2>";
	}
}
?>
<div id="user_pro_room" role="navigation"> </div>


<h2  style="margin:1em 0 .5em 0; display:block !important;" ><span style="position: absolute;left:-9000px;">Optionen </span><a aria-hidden = "true"  tabindex="0" title="<?php echo _OPT_TITLE; ?>" style="text-decoration:none; background-color:transparent;" onclick="klapp('ae'); return false;" onkeypress="klapp('ae'); return false;"><span id="einaus_ae" ><?php _OPT ?></span></a></h2>



<div id="ae">


<form id ="opt1" method="post">

<?php
 
################# Schriftgröße ####################
// if ($s != 7 && $s != 12) {
if ($s != 12) {
	echo '<div class="opt"><p><label for="schrift"> '._FONTSIZE.' (80…175)</label> <input type="number" min="80" max="175" name="schrift" id="schrift" style="width:3.5em" onchange=" CookieSetz(\'schrift\',this.form.schrift.value,360);this.form.submit();" value="'.$schrift.'" ></p></div>';
}

################# Bildgröße ####################
// if ($s != 7 && $s != 12) {
if ($s != 12) {
	echo '<div class="opt"><p><label for="img_size"> '._PICSIZE.' (36…'.$maxheight.')</label> <input type="number" min="36" max="'.$maxheight.'" name="img_size" id="img_size" style="width:3.5em" onchange=" CookieSetz(\'img_size\',this.form.img_size.value,360);this.form.submit();" value="'.$img_size.'" ></p></div>';
}


################## reverse ########################
if (isset($display_reverse_user) && $display_reverse_user === true && $s != 7) {		
	if ($rev == "1") {
		$chk2="checked";
		echo '<input type="hidden" name="rev" value="0">';
	} else {
		$chk2="";
	}
	echo '<div class="opt"><p><input type="checkbox" '.$chk2.' id="reverse" name="rev" value="1" onchange="this.form.submit();"><label for="reverse" title="'._TIT_REVERSE.'" > '._REVERSE.'</label></p></div>';	
}

############### mehrzeilig ########################
// if ($s != 7 && $s != 11) {
// 	if ($m == "1") {
// 		$chk3="checked";
// 		echo '<input type="hidden" name="m" value="0">';
// 	} else {
// 		$chk3="";
// 	}
// 	echo '<div class="opt" id="zeilen"><p><input type="checkbox" '.$chk3.' id="mehrzeilig" name="m" value="1" onchange="this.form.submit();"><label for="mehrzeilig" title="'._TIT_TEXTAREA.'" > '._TEXTAREA.'</label></p></div>';
// }
############### Datum und Uhrzeit im Chatfenster ########################
// if ($s != 11 ) {
	if ($dc == "0") {
		$chk4="checked";
		echo '<input type="hidden" name="dc" value="1">';
	} else {
		$chk4="";
	}
	echo '<div class="opt"><p><input type="checkbox" '.$chk4.' id="datum" name="dc" value="0" onchange="this.form.submit();"><label for="datum" title="'._TIT_DATEOFF.'" > '._DATEOFF.'</label></p></div>';	

	if ($uhr == "0") {
		$chk5="checked";
		echo '<input type="hidden" name="uhr" value="1">';
	} else {
		$chk5="";
	}
	echo '<div class="opt"><p><input type="checkbox" '.$chk5.' id="uhr" name="uhr" value="0" onchange="this.form.submit();"><label for="uhr" title="'._TIT_TIMEOFF.'" > '._TIMEOFF.'</label></p></div>';	
// }

############### Bilder ########################
if ($pic == "0") {
	$chk6="checked";
	echo '<input type="hidden" name="pic" value="1">';
} else {
	$chk6="";
}
echo '<div class="opt"><p><input type="checkbox" '.$chk6.' id="pic" name="pic" value="0" onchange="this.form.submit();"><label for="pic" title="'._TIT_HIDE_PICS.'" > '._HIDE_PICS.'</label></p></div>';	

############### freeze Gifs ########################
if ($freeze == "0") {
	$chk21="checked";
	echo '<input type="hidden" name="freeze" value="1">';
} else {
	$chk21="";
}
echo '<div class="opt"><p><input type="checkbox" '.$chk21.' id="freeze" name="freeze" value="0" onchange="this.form.submit();"><label for="freeze" title="'._TIT_FREEZE_GIFS.'" > '._FREEZE_GIFS.'</label></p></div>';	

############### Avatare ########################
if ($s != 12) {
	if ($avt == "0") {
		$chk7="checked";
		echo '<input type="hidden" name="avt" value="1">';
	} else {
		$chk7="";
	}
}	
echo '<div class="opt"><p><input type="checkbox" '.$chk7.' id="avt" name="avt" value="0" onchange="this.form.submit();"><label for="avt" title="'._TIT_HIDE_AVATAR.'" > '._HIDE_AVATAR.'</label></p></div>';	


############### Bilder kleiner ########################
// if ($smallpic == "1") {
// 	$chk26="checked";
// 	echo '<input type="hidden" name="smallpic" value="0">';
// } else {
// 	$chk26="";
// }
// echo '<div class="opt"><p><input type="checkbox" '.$chk26.' id="smallpic" name="smallpic" value="1" onchange="this.form.submit();"><label for="smallpic" title="'._TIT_SMALL_PICS.'" > '._SMALL_PICS.'</label></p></div>';

// ############### User-online-Anzeige ########################
// if ($show_user != "no") {
// 	if ($uoa == "0") {
// 		$chk16="checked";
// 		echo '<input type="hidden" name="uoa" value="1">';
// 	} else {
// 		$chk16="";
// 	}
// 	echo '<div class="opt"><p><input type="checkbox" '.$chk16.' id="uoa" name="uoa" value="0" onchange="this.form.submit();"><label for="uoa" title="'._TIT_HIDE_UO.'" > '._HIDE_UO.'</label></p></div>';
// }

############### Sound ########################
//if ($s != 7) {
	if ($sound == "0") {
		$chk8="checked";
		echo '<input type="hidden" name="sound" value="1">';
	} else {
		$chk8="";
	}
	echo '<div class="opt" id="soundwahl"><p><input type="checkbox" '.$chk8.' id="sound" name="sound" value="0" onchange="this.form.submit();"><label for="sound" title="'._TIT_SOUNDOFF.'" > '._SOUNDOFF.'</label></p></div>';	
	//}

############### bg mobil ########################
if ($s == 7) {
	if ($bg_mob == "1") {
		$chk18="checked";
		echo '<input type="hidden" name="bg_mob" value="0">';
	} else {
		$chk18="";
	}
	echo '<div class="opt" id="bg_mobil"><p><input type="checkbox" '.$chk18.' id="bg_mob" name="bg_mob" value="1" onchange="this.form.submit();"><label for="bg_mob" title="'._TIT_BG_MOB.'" > '._BG_MOB.'</label></p></div>';	
}


############### bg mobil dark ########################
if ($s == 7 && $wo != "DarkRoom") {
	if ($dark == "1") {
		$chk20="checked";
		echo '<input type="hidden" name="dark" value="0">';
	} else {
		$chk20="";
	}
	echo '<div class="opt" id="dark"><p><input type="checkbox" '.$chk20.' id="bg_dark" name="dark" value="1" onchange="this.form.submit();"><label for="bg_dark" title="'._TIT_BG_MOB_DARK.'" > '._BG_MOB_DARK.' </label></p></div>';
}

############### enable dark mode ########################
if ($s == 7 || $s == 8 || $s == 10 || $s == 13 || $s == 14) {

	if ($enable_dark == "1") {
		$chk19="checked";
		echo '<input type="hidden" name="enable_dark" value="0">';
	} else {
		$chk19="";
	}
	
	// echo '<div class="opt" id="dark"><p><input type="checkbox" '.$chk20.' id="bg_dark" name="dark" value="1" onchange="this.form.submit();"><label for="bg_dark" title="' . constOrDefault('_TIT_ENAB_DARK') . '" > ' . constOrDefault('_ENAB_DARK') . ' </label></p></div>';
	
	
	 echo '<div class="opt" id="enab_dark"><p><input type="checkbox" '.$chk19.' id="enable_dark" name="enable_dark" value="1" onchange="this.form.submit();"><label for="enable_dark" title="'.constOrDefault('_TIT_ENAB_DARK').'" > '.constOrDefault('_ENAB_DARK').'</label></p></div>';
	// echo '<div class="opt" id="enab_dark"><p><input type="checkbox" '.$chk19.' id="enable_dark" name="enable_dark" value="1" onchange="this.form.submit();"><label for="enab_dark" title="'._TIT_ENAB_DARK.'" > Dark Mode erlauben</label></p></div>';
}



############### Popup ########################
// if ($s != 7 && $s != 11 && isMobile() !== true) {
// 	if (isset($popup) && $popup == "enable") {
// 		if ($pops == "zeigen") {
// 			$chk9="checked";
// 			echo '<input type="hidden" name="pop_up" value="aus">';
// 		} else {
// 			$chk9="";
// 		}
// 		echo '<div id="popup" class="opt"><p><input type="checkbox" '.$chk9.' id="pop_up" name="pop_up" value="zeigen" onchange="this.form.submit();"><label for="pop_up" title="'._TIT_SHOW_POPUP.'" > '._SHOW_POPUP.'</label></p></div>';
// 	}
// }

############### Fettschrift ########################
if ($s != 6) {
	if ($nickfarben == "0") {
		$chk10="checked";
		echo '<input type="hidden" name="nickfarben" value="1">';
	} else {
		$chk10="";
	}
	echo '<div class="opt"><p><input type="checkbox" '.$chk10.' id="nickfarben" name="nickfarben" value="0" onchange="this.form.submit();"><label for="nickfarben" title="'._TIT_COLOROFF.'" > '._COLOROFF.'</label></p></div>';	
}

############### Schriftfarben ausschalten ########################
if (!isset($usercolor) || $usercolor=="auto") {
	if ($s != 11) {
		if ($nickfarben2 == "0") {
			$chk11="checked";
			echo '<input type="hidden" name="nickfarben2" value="1">';
		} else {
			$chk11="";
		}
		echo '<div class="opt"><p><input type="checkbox" '.$chk11.' id="nickfarben2" name="nickfarben2" value="0" onchange="this.form.submit();"><label for="nickfarben2" title="'._TIT_COLOR2OFF.'" > '._COLOR2OFF.'</label></p></div>';	
	}
}


############### Chat Up Player ########################
if (($admintrue || $modtrue || (isset($chat_up_player_all) && $chat_up_player_all === true)) && file_exists("chat_up_player_inc.php") && $s != 7 && $s !=12 && !isset($no_chat_up_player) ) {
	if ($chat_up_player == "0") {
		$chk14="checked";
		echo '<input type="hidden" name="chat_up_player" value="1">';
	} else {
		$chk14="";
	}
	echo '<div class="opt"><p><input type="checkbox" '.$chk14.' id="chat_up_player" name="chat_up_player" value="0" onchange="this.form.submit();"><label for="chat_up_player" title="'._TIT_SHOW_UP_PLAYER.'" > '._SHOW_UP_PLAYER.'</label></p></div>';	
}


?>

<!-- um bei Optionswechsel im Raum zu bleiben: -->
<p><input type="hidden" name="room" value ="<?php echo $wo ?>" ></p>


</form>


<div id ="opt2">

<h3 class="dot"><?php echo _NICKCOLOR; ?></h3>
<form id="form">
<p>
<label for="menu3"><?php echo _NICKCOLOR; ?></label>
<input type="color" style="margin-left: 0;border:0;background:transparent;vertical-align:-20%;max-width:2em" name="menu3" id="menu3" value = "#<?php echo $color ?>" onchange="jump_color(this.form);klapp('ae');">
	
	
</p>
</form>


<?php
if (!isset($stil) || $stil == 0) {
$star2 = $star3 = $star4 = $star5 = $star6 = $star7 = $star8 = $star9 = $star10 = $star11= $star12 =$star13 =$star14 =$star15 = "";
if ($s == 2) $star2 = "* ";
if ($s == 3) $star3 = "* ";
if ($s == 4) $star4 = "* ";
if ($s == 5) $star5 = "* ";
if ($s == 6) $star6 = "* ";
if ($s == 61) $star61 = "* ";
if ($s == 7) $star7 = "* ";
if ($s == 8) $star8 = "* ";
if ($s == 9) $star9 = "* ";
if ($s == 10) $star10 = "* ";
if ($s == 11) $star11 = "* ";
if ($s == 12) $star12 = "* ";
if ($s == 13) $star13 = "* ";
if ($s == 14) $star14 = "* ";
if ($s == 15) $star15 = "* ";

echo '
<h3 class="dot">'._SKIN.'</h3>
<form id="form2" method="post">
<p>
<label class="dot" for="menu2">'._SKINLABEL.':</label>
<select name="menu2" id="menu2" onchange="jump2(this.form);" >
<option value="" selected="selected" >'._SKINS.'</option>
';

// if (file_exists("chatcss2.php")) {echo '<option lang="en" xml:lang="en" style="background:#FAFAEE; color:#000000" value="2">'.$star2.'Boxes</option>';}
if (file_exists("chatcss7.php"))  {echo '<option id="mobile_skin" style="background:#ffffff; color:#000000" value="7">'.$star7.'Mobil</option>';}
if (file_exists("chatcss61.php")) {echo '<option style="background:#fff1fa; color:#cc0000" value="61">'.$star61.'Bannychat</option>';}
if (file_exists("chatcss8.php"))  {echo '<option style="background:#FFFFFF; color:#000000" value="8">'.$star8.'Firebox</option>';}
if (file_exists("chatcss10.php")) {echo '<option style="background:#E2E2FF; color:#000000" value="10">'.$star10.'Sky</option>';}
if (file_exists("chatcss13.php")) {echo '<option style="background:#e3ded1; color:#000000" value="13">'.$star13.'Messenger</option>';}
if (file_exists("chatcss14.php")) {echo '<option style="background:#ae210d; color:#ffffff" value="14">'.$star14.'Foto</option>';}
if (file_exists("chatcss3.php"))  {echo '<option style="background:#FFFBCC; color:#000000" value="3">'.$star3.'Web 2</option>';}
if (file_exists("chatcss4.php"))  {echo '<option style="background:#000000; color:#FFFFFF" value="4">'.$star4.'Black</option>';}
if (file_exists("chatcss9.php"))  {echo '<option style="background:#222222; color:#FFFFFF" value="9">'.$star9.'Chevys Skin</option>';}
if (file_exists("chatcss15.php") && file_exists("bg_video.php") ) {echo '<option style="background:#FFD700; color:#000000" value="15">'.$star15.'Fire</option>';}

if (file_exists("chatcss11.php")) {echo '<option style="background:#000088; color:#ffff00; font-weight:bold" value="11">'.$star11.'Invers</option>';}
if (file_exists("chatcss5.php")) {echo '<option lang="en" xml:lang="en" style="background:#446644; color:#FFFFFF" value="5">'.$star5.'Stage</option>';}
if (file_exists("chatcss6.php"))  {echo '<option style="background:#fff1fa; color:#cc0000" value="6">'.$star6.'Flowers</option>';}
if (file_exists("chatcss12.php")) {echo '<option style="background:#000088; color:#ffff00; font-weight:bold" value="12">'.$star12.'BF-Linear</option>';}
	
echo'	
</select>
</p>
</form>
';
}



if ($s == 12) {	
				
	echo '<div class="sizer" aria-hidden="true">
		<h3>Schriftgr&ouml;&szlig;e: </h3>';
		if ($font_size==125) {
			echo '<span style="font-size: 90%" title= "Schriftgr&ouml;&szlig;e 100%">A</span>';
		} else {
			echo'<a href="" style="font-size: 90%" title= "Schriftgr&ouml;&szlig;e 100%"  onclick="CookieSetz(\'size\',\'100\',360); " >A</a>';
		}

		if ($font_size==170) {
			echo '<span style="font-size: 120%" title= "Schriftgr&ouml;&szlig;e 200%">A</span>';
		} else {
			echo'<a href="" style="font-size: 120%" title= "Schriftgr&ouml;&szlig;e 200%" onclick="CookieSetz(\'size\',\'200\',360); " >A</a>';
		}
		
		if ($font_size==300) {
			echo '<span style="font-size: 150%" title= "Schriftgr&ouml;&szlig;e 300%">A</span>';
		} else {
			echo'<a href="" style="font-size: 150%" title= "Schriftgr&ouml;&szlig;e 300%" onclick="CookieSetz(\'size\',\'300\',360); " >A</a>';
		}
				
	echo '</div>';
}	

?>		
		
		

</div>


</div>


<?php
//if ($in_regdb && isset($create_profile) && $create_profile == "yes"  && file_exists("profil.php") && !file_exists("rooms/Offline")  && $tmp_closed !== true && $s != 12  || $admintrue) {
if ($in_regdb && isset($create_profile) && $create_profile == "yes"  && file_exists("profil.php") && !file_exists("rooms/Offline")  && $tmp_closed !== true && $s != 12  || $admintrue) {
	// echo' <p class="logout" style="margin-top: .5em;  clear:left;"><a style="font-weight:bold;" href="profil.php?token='.urlencode($_SESSION["access_token"]).'">'._PROFIL.'</a></p> ';

	echo '<p class="logout" style="margin-top:.5em; clear:left;">
		<a href="profil.php?token='.urlencode($_SESSION["access_token"]).'"
		   style="font-weight:bold;"
		   onclick="window.open(this.href,\'profil\',\'width=750,height=750,resizable=yes,scrollbars=yes\'); return false;">
			'._PROFIL.'
		</a>
	</p>';

} 

if (!$in_regdb && !file_exists("rooms/Offline")  && $tmp_closed !== true) {
	echo' <p class="logout" style="margin-top: .5em;  clear:left;"><a style="font-weight:bold;" href="reg.php?token='.urlencode($_SESSION["access_token"]).'">'._REGDICH.'</a></p> ';	
} 

if ($in_regdb ) {
	if (file_exists("abuse.php")) {
	echo' <p class="logout" style="margin-top: .5em;  clear:left;"><a style="font-weight:bold;" href="/abuse.php" target="_blank" >Abuse (Missbrauch melden)</a></p> ';
	}
}


?>


<!-- <p id="logout"  style="clear:left"><a style="font-weight:bold; text-decoration:none;" title="Logout" href="logout.php"  >X … Logout! </a></p> -->

<p id="logout"  style="clear:left"><a style="font-weight:bold; text-decoration:none;" title="Logout" href="logout.php"  ><span style="font-family:wigners_friendroman;font-size:1.8em;line-height:0;position: relative;top: 3px;color:inherit">&#x23FB;</span> … Logout! </a></p>




<!-- https://qastack.com.de/programming/5927284/how-can-i-make-setinterval-also-work-when-a-tab-is-inactive-in-chrome -->
<!-- https://github.com/turuslan/HackTimer -->
<!-- <script src="HackTimer.min.js"></script> -->


<!-- <script src="chat_js.php"></script> -->
<script src="chat_js.php?<?php echo filemtime("chat_js.php") ?>"></script>


<!-- <?php if (isMobile() !== true) {echo' <script src="popbild.js?'.time().'" defer></script> ';} ?> -->


<script src="micoxUpload2.js" defer></script>

<!-- Player Uploads -->
<?php if (($admintrue || (isset($chat_up_player_all) && $chat_up_player_all === true)) && file_exists("chat_up_player.php") && $s != 7 && $s !=12 && $chat_up_player == "0") { 
	
	echo '<iframe src="chat_up_player.php" style="display:block;border:0;width:99%;max-width:unset;height:200px;margin-bottom:2em;resize:vertical;background:transparent">';	
	// include ('chat_up_player_inc.php');
}
?>

<!-- Player HTML5 Radio -->
<?php if (file_exists("html5player_inc.php")  && $s !=12 && $html5player == "0") { 
	include ('html5player_inc.php');
} ?>

<!-- Webradio-Player -->
<?php
// clearstatcache(); // https://www.php-resource.de/de/php-manual/function.clearstatcache.html

	// das simple webradio
	if (file_exists("webradio_inc.php")  && $s != 12  && $wo == $standard ) {
		include_once ('webradio_inc.php');
	} else {

		if (file_exists("webradio/webradio_inc.php")  && $s != 12 && $s != 7 && $wo == $standard  ) {
			include_once ('webradio/webradio_inc.php');
		}

		if (file_exists("webradio/webradio_pop.php") && $s == 7) {
			echo "<p id='antenna' class='logout' style='padding:3px 0'><a href='webradio/webradio_pop.php' onclick='hide_antenna()' target='Radio'><img  src='img/radio-antenna.png' alt='Radio' style='display:inline-block;vertical-align:middle;width:40px;height:33px' ></a></p>";
		} elseif (file_exists("webradio/webradio_pop_radios.php") && $s == 7) {
			echo "<p id='antenna' class='logout' style='padding:3px 0'><a href='webradio/webradio_pop_radios.php' onclick='hide_antenna()' target='Radio'><img  src='img/radio-antenna.png' alt='Radio' style='display:inline-block;vertical-align:middle;width:40px;height:33px' ></a></p>";
		}
	}

	if (file_exists("google_review.php") ) {
		include ('google_review.php');
	}

	if (file_exists("webradio/video-popup.php")  && $s != 12 && $wo == $standard  ) {
		include_once ('webradio/video-popup.php');
	}

?>


</fieldset>

<!-- die Sounds -->
<?php if ($sound != "0") {echo' <div id="ton"></div>';} ?>

<?php 
if ($anz_rooms == 1) echo '<div id="uo"> </div>';
?>



</fieldset>



<script>
		
	if( window.innerHeight == screen.height) {
		if (document.getElementById("popout_icon")) {
			var x = document.getElementById("popout_icon");
			x.style.display = "none";
		}
	}
		
	if (screen.width <= 720) {
		if (document.getElementById("menu2")) {
			document.getElementById("menu2").style.display = "none";
		}    
	}
	
	function hide_antenna(){
		if (document.getElementById("antenna")) {
			var x = document.getElementById("antenna");
			x.style.display = "none";
		}
	}	
	
	// Chat nicht in mehreren Fenstern / Tabs öffnen
	// iOS und Android-Geräte ausschließen
	// if (/iPhone|iPad|iPod|Android/i.test(navigator.userAgent)) {
	// if (/Android/i.test(navigator.userAgent)) {
	// 	// do nothing
	// } else {
		// Auf allen anderen Geräten Locking anwenden
		let chatStatus = sessionStorage.getItem("chat_open");
		// console.log("Chat-Status beim Laden:", chatStatus !== null ? chatStatus : "Noch nicht gesetzt");

		// Prüfen, ob der Chat bereits in einem anderen Tab läuft
		if (localStorage.getItem("chat_open")) {
			if (!sessionStorage.getItem("chat_open")) { 
				alert("Der Chat ist bereits in einem anderen Tab geöffnet!\nBitte schließe alle anderen Tabs, in denen der Chat läuft");
				localStorage.removeItem("chat_open");
				window.location.href = "logout.php";
			}
		} else {
			localStorage.setItem("chat_open", "true");
			sessionStorage.setItem("chat_open", "true");
			console.log("🔒 Chat-Lock wurde gesetzt – weitere Tabs sind blockiert.");
		}

		// Lock entfernen, wenn der Tab geschlossen oder neu geladen wird
		window.addEventListener("beforeunload", function() {
			localStorage.removeItem("chat_open");
			console.log("🔓 Lock entfernt (Tab geschlossen oder neu geladen).");
		});

		// Live-Erkennung für andere Tabs
		window.addEventListener("storage", function(event) {
			if (event.key === "chat_open" && event.newValue && !sessionStorage.getItem("chat_open")) {
				alert("Der Chat wurde bereits in einem anderen Tab geöffnet!\nBitte schließe alle anderen Tabs, in denen der Chat läuft.");
				window.location.href = "logout.php";
			}
		});
	// }

	if (document.getElementById('hide_message')) {
	document.getElementById('hide_message').addEventListener('click', function() {
		// Setze das Cookie
		document.cookie = "hide_message=true; max-age=86400";
		document.getElementById("message").style.display = "none";
	});
}

 
function toggleSmileys() {
	const smileys = document.getElementById("more-smileys");
	const isVisible = smileys.style.display === "inline";

	if (isVisible) {
		smileys.style.display = "none";
		document.getElementById("toggle_smileys").innerHTML=":-) <span>▷</span>";
		localStorage.setItem("smileysVisible", "false");
	} else {
		smileys.style.display = "inline";
		document.getElementById("toggle_smileys").innerHTML=":-) <span style='display:inline-block; transform: rotate(180deg);'>▷</span>";
		localStorage.setItem("smileysVisible", "true");
	}
}

// Beim Laden den Zustand wiederherstellen
window.addEventListener("DOMContentLoaded", () => {
	const smileys = document.getElementById("more-smileys");
	const toggleButton = document.getElementById("toggle_smileys");

	const saved = localStorage.getItem("smileysVisible");
	if (saved === "true") {
		smileys.style.display = "inline";
		document.getElementById("toggle_smileys").innerHTML=":-) <span style='display:inline-block; transform: rotate(180deg);'>▷</span>";
	}
});
 
 
// reload, wenn $ab_offen erreicht: 
(function() {
	// const zielSekunden = <?php echo isset($ab_offen) ? (int)$ab_offen : 0; ?>;
	const zielSekunden = <?= $ab_offen_seconds ?>;
	const jetzt = new Date();
	const sekJetzt = jetzt.getHours() * 3600 + jetzt.getMinutes() * 60 + jetzt.getSeconds();

	const differenz = zielSekunden - sekJetzt;

	// Wenn wir im Fenster von - 10s bis + 15min zur Zielzeit sind
	if (differenz <= 900 && differenz > -10 && document.cookie.indexOf('reload_done=1') === -1) {
		const interval = setInterval(function() {
			const jetzt = new Date();
			const sek = jetzt.getHours() * 3600 + jetzt.getMinutes() * 60 + jetzt.getSeconds();

			if (sek >= zielSekunden) {
				document.cookie = 'reload_done=1; max-age=300;';
				clearInterval(interval);
				location.reload();
			}
		}, 1000);
	}
})(); 
 
 
// Poster-Dummy (nur) für iOS
const isIOS = /iPad|iPhone|iPod/.test(navigator.userAgent) && !window.MSStream;

if (isIOS) {
	function setPoster(video) {
		if (!video.hasAttribute('poster')) {
			video.setAttribute('poster', 'img/vid_dummy_bw.webp');
		}
	}
		  
	// Bereits vorhandene Videos behandeln (falls schon da)
	//document.querySelectorAll('video').forEach(setPoster);

	// Beobachter für neue Videos im DOM
	const target = document.getElementById('wall');
	if (target) {
		const observer = new MutationObserver(mutations => {
			mutations.forEach(mutation => {
				mutation.addedNodes.forEach(node => {
					if (node.tagName === 'VIDEO') {
						setPoster(node);
					} else if (node.querySelectorAll) {
						node.querySelectorAll('video').forEach(setPoster);
					}
				});
			});
		});

		observer.observe(target, { childList: true, subtree: true });
	}
}
 
let chatuser = "<?php echo $_SESSION['chatuser']; ?>";
console.log('chatuser: ' + chatuser);
 
 
</script>
  
<?php if (file_exists("footer_inc.php")) include("footer_inc.php"); ?>


</body>
</html>
